/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.util.StringRepresentable;

public enum CamelVariant implements StringRepresentable
{
    DESERT(0, "minecraft", "camel"),
    ARID(1, "atmospheric", "camel_arid"),
    HYBRID(2, "atmospheric", "camel_hybrid");

    private static final IntFunction<CamelVariant> BY_ID;
    public static final Codec<CamelVariant> CODEC;
    private final int id;
    private final ResourceLocation location;
    private final LazyLoadedValue<ResourceLocation> texture = new LazyLoadedValue(() -> new ResourceLocation(this.location().m_135827_(), "textures/entity/camel/" + this.location().m_135815_() + ".png"));

    private CamelVariant(int id, String modid, String name) {
        this(id, new ResourceLocation(modid, name));
    }

    private CamelVariant(int id, ResourceLocation location) {
        this.id = id;
        this.location = location;
    }

    public String m_7912_() {
        return this.location.toString();
    }

    public int id() {
        return this.id;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public ResourceLocation texture() {
        return (ResourceLocation)this.texture.m_13971_();
    }

    public static CamelVariant byId(int id) {
        return BY_ID.apply(id);
    }

    static {
        BY_ID = ByIdMap.m_262845_(CamelVariant::id, (Object[])CamelVariant.values(), (Object)((Object)DESERT));
        CODEC = StringRepresentable.m_216439_(CamelVariant::values);
    }
}

