/*
 * Decompiled with CFR 0.152.
 */
package io.github.sirjain0.perfectplushies.datagen;

import com.nyfaria.perfectplushieapi.api.PlushieStore;
import io.github.sirjain0.perfectplushies.init.BlockInit;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput generator, ExistingFileHelper existingFileHelper) {
        super(generator, "perfectplushies", existingFileHelper);
    }

    protected void registerModels() {
        PlushieStore.plushieBlocks.stream().map(Supplier::get).filter(block -> block != BlockInit.DUMBO_BLOB_PLUSHIE.get()).forEach(this::simpleBlockItemModel);
        PlushieStore.playerBlocks.stream().map(Supplier::get).forEach(this::playerPlushieItemModel);
    }

    protected ItemModelBuilder simpleBlockItemModel(Block block) {
        String name = this.getName(block);
        return (ItemModelBuilder)this.withExistingParent(name, this.modLoc("block/" + name));
    }

    protected ItemModelBuilder playerPlushieItemModel(Block block) {
        String name = this.getName(block);
        return (ItemModelBuilder)this.withExistingParent(name, this.modLoc("item/player_plushie"));
    }

    protected ItemModelBuilder spawnEgg(Item block) {
        String name = this.getName(block);
        return (ItemModelBuilder)this.withExistingParent(name, this.mcLoc("item/template_spawn_egg"));
    }

    protected ItemModelBuilder simpleGeneratedModel(Item item) {
        return this.simpleModel(item, this.mcLoc("item/generated"));
    }

    protected ItemModelBuilder simpleHandHeldModel(Item item) {
        return this.simpleModel(item, this.mcLoc("item/handheld"));
    }

    protected ItemModelBuilder simpleModel(Item item, ResourceLocation parent) {
        String name = this.getName(item);
        return (ItemModelBuilder)this.singleTexture(name, parent, "layer0", this.modLoc("item/" + name));
    }

    protected String getName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    protected String getName(Block item) {
        return ForgeRegistries.BLOCKS.getKey((Object)item).m_135815_();
    }
}

