/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.events;

import com.pedrorok.hypertube.config.ServerConfig;
import com.pedrorok.hypertube.core.placement.TubePlacement;
import com.pedrorok.hypertube.core.travel.TravelConstants;
import com.pedrorok.hypertube.core.travel.TravelManager;
import com.pedrorok.hypertube.utils.TubeUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="create_hypertube")
public class ModServerEvents {
    @SubscribeEvent
    public static void onServerStart(ServerStartingEvent event) {
        ServerConfig.get().init();
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity living = event.getEntity();
        if (!TravelConstants.TRAVELLER_ENTITIES.contains(living.m_6095_())) {
            return;
        }
        TravelManager.entityTick(living);
        if (living.m_9236_().f_46443_) {
            return;
        }
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        TubePlacement.tickPlayerServer(player);
    }

    @SubscribeEvent
    public static void entityHitboxChangesWhenInHypertube(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        if (!TravelManager.hasHyperTubeData(entity)) {
            return;
        }
        event.setNewSize(EntityDimensions.m_20398_((float)0.5f, (float)0.5f));
        if (entity.m_9236_().f_46443_) {
            return;
        }
        entity.m_20124_(Pose.CROUCHING);
    }

    @SubscribeEvent
    public static void playerPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (TravelManager.hasHyperTubeData(event.getEntity())) {
            event.setCanceled(true);
            return;
        }
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (TubeUtils.checkPlayerPlacingBlock(player, (Level)event.getLevel(), event.getPos())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void playerBreakBlock(BlockEvent.BreakEvent event) {
        if (!TravelManager.hasHyperTubeData((Entity)event.getPlayer())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingDamageEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (TravelManager.hasHyperTubeData((Entity)entity)) {
            event.setAmount(0.0f);
            event.setCanceled(true);
            return;
        }
        if (!entity.getPersistentData().m_128471_("hypertube_immunity")) {
            return;
        }
        entity.getPersistentData().m_128379_("hypertube_immunity", false);
        if (entity.getPersistentData().m_128454_("last_travel_time") < System.currentTimeMillis()) {
            return;
        }
        event.setAmount(0.0f);
        event.setCanceled(true);
        entity.f_19864_ = true;
    }
}

