/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture.converter;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.mortuusars.exposure.camera.capture.Capture;
import io.github.mortuusars.exposure.camera.capture.converter.IImageToMapColorsConverter;
import io.github.mortuusars.exposure.util.Color;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.MapColor;

public class DitheringColorConverter
implements IImageToMapColorsConverter {
    private final double[] shadeCoeffs = new double[]{0.71, 0.86, 1.0, 0.53};

    public static MapColor[] getMapColors() {
        MapColor[] colors = new MapColor[64];
        for (int i = 0; i <= 63; ++i) {
            colors[i] = MapColor.m_284175_((int)i);
        }
        return colors;
    }

    @Override
    public byte[] convert(Capture capture, NativeImage image) {
        return this.convert(image);
    }

    @Override
    public byte[] convert(NativeImage image) {
        int[][] pixels = this.convertToPixelArray(image);
        return this.convert(pixels);
    }

    public byte[] convert(int[][] pixels) {
        MapColor[] mapColors = (MapColor[])Arrays.stream(DitheringColorConverter.getMapColors()).filter(Objects::nonNull).toArray(MapColor[]::new);
        int width = pixels[0].length;
        int height = pixels.length;
        byte[] bytes = new byte[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color imageColor = new Color(pixels[y][x], true);
                byte b = (byte)this.floydDither(mapColors, pixels, x, y, imageColor);
                if (imageColor.getAlpha() == 0) {
                    b = (byte)MapColor.f_283808_.f_283805_;
                }
                bytes[x + y * width] = b;
            }
        }
        return bytes;
    }

    private int floydDither(MapColor[] mapColors, int[][] pixels, int x, int y, Color imageColor) {
        Color pixelColor;
        int colorIndex = this.nearestColor(mapColors, imageColor);
        Color palletedColor = this.mapColorToRGBColor(mapColors, colorIndex);
        NegatableColor error = new NegatableColor(imageColor.getRed() - palletedColor.getRed(), imageColor.getGreen() - palletedColor.getGreen(), imageColor.getBlue() - palletedColor.getBlue());
        if (pixels[0].length > x + 1) {
            pixelColor = new Color(pixels[y][x + 1], true);
            pixels[y][x + 1] = this.applyError(pixelColor, error, 0.4375);
        }
        if (pixels.length > y + 1) {
            if (x > 0) {
                pixelColor = new Color(pixels[y + 1][x - 1], true);
                pixels[y + 1][x - 1] = this.applyError(pixelColor, error, 0.1875);
            }
            pixelColor = new Color(pixels[y + 1][x], true);
            pixels[y + 1][x] = this.applyError(pixelColor, error, 0.3125);
            if (pixels[0].length > x + 1) {
                pixelColor = new Color(pixels[y + 1][x + 1], true);
                pixels[y + 1][x + 1] = this.applyError(pixelColor, error, 0.0625);
            }
        }
        return colorIndex;
    }

    private int applyError(Color pixelColor, NegatableColor error, double quantConst) {
        int pR = Mth.m_14045_((int)(pixelColor.getRed() + (int)((double)error.r * quantConst)), (int)0, (int)255);
        int pG = Mth.m_14045_((int)(pixelColor.getGreen() + (int)((double)error.g * quantConst)), (int)0, (int)255);
        int pB = Mth.m_14045_((int)(pixelColor.getBlue() + (int)((double)error.b * quantConst)), (int)0, (int)255);
        return new Color(pR, pG, pB, pixelColor.getAlpha()).getRGB();
    }

    private Color mapColorToRGBColor(MapColor[] colors, int color) {
        Color mcColor = new Color(colors[color >> 2].f_283871_);
        double[] mcColorVec = new double[]{mcColor.getRed(), mcColor.getGreen(), mcColor.getBlue()};
        double coeff = this.shadeCoeffs[color & 3];
        return new Color((int)(mcColorVec[0] * coeff), (int)(mcColorVec[1] * coeff), (int)(mcColorVec[2] * coeff));
    }

    private double[] applyShade(double[] color, int ind) {
        double coeff = this.shadeCoeffs[ind];
        return new double[]{color[0] * coeff, color[1] * coeff, color[2] * coeff};
    }

    private int nearestColor(MapColor[] colors, Color imageColor) {
        double[] imageVec = new double[]{(double)imageColor.getRed() / 255.0, (double)imageColor.getGreen() / 255.0, (double)imageColor.getBlue() / 255.0};
        int best_color = 0;
        double lowest_distance = 10000.0;
        for (int k = 0; k < colors.length; ++k) {
            Color mcColor = new Color(colors[k].f_283871_);
            double[] mcColorVec = new double[]{(double)mcColor.getRed() / 255.0, (double)mcColor.getGreen() / 255.0, (double)mcColor.getBlue() / 255.0};
            for (int shadeInd = 0; shadeInd < this.shadeCoeffs.length; ++shadeInd) {
                double distance = this.distance(imageVec, this.applyShade(mcColorVec, shadeInd));
                if (!(distance < lowest_distance)) continue;
                lowest_distance = distance;
                best_color = k == 0 && imageColor.getAlpha() == 255 ? 119 : k * this.shadeCoeffs.length + shadeInd;
            }
        }
        return best_color;
    }

    private double distance(double[] vectorA, double[] vectorB) {
        return Math.sqrt(Math.pow(vectorA[0] - vectorB[0], 2.0) + Math.pow(vectorA[1] - vectorB[1], 2.0) + Math.pow(vectorA[2] - vectorB[2], 2.0));
    }

    private int[][] convertToPixelArray(NativeImage image) {
        int width = image.m_84982_();
        int height = image.m_85084_();
        int[][] result = new int[height][width];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgba;
                result[y][x] = rgba = Color.BGRtoRGB(image.m_84985_(x, y));
            }
        }
        return result;
    }

    private record NegatableColor(int r, int g, int b) {
    }
}

