/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancement.trigger;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.advancement.predicate.CameraPredicate;
import io.github.mortuusars.exposure.advancement.predicate.ExposurePredicate;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.List;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class FrameExposedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = Exposure.resource("frame_exposed");

    @NotNull
    public ResourceLocation m_7295_() {
        return ID;
    }

    @NotNull
    protected TriggerInstance createInstance(JsonObject json, @NotNull ContextAwarePredicate predicate, @NotNull DeserializationContext deserializationContext) {
        CameraPredicate camera = CameraPredicate.fromJson(json.get("camera"));
        ExposurePredicate exposure = ExposurePredicate.fromJson(json.get("exposure"));
        LocationPredicate location = LocationPredicate.m_52629_((JsonElement)json.get("location"));
        return new TriggerInstance(predicate, camera, exposure, location);
    }

    public void trigger(ServerPlayer player, ItemAndStack<CameraItem> camera, CompoundTag frame, List<Entity> entitiesInFrame) {
        this.m_66234_(player, triggerInstance -> triggerInstance.matches(player, camera, frame, entitiesInFrame));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final CameraPredicate cameraPredicate;
        private final ExposurePredicate exposurePredicate;
        private final LocationPredicate locationPredicate;

        public TriggerInstance(ContextAwarePredicate predicate, CameraPredicate cameraPredicate, ExposurePredicate exposurePredicate, LocationPredicate locationPredicate) {
            super(ID, predicate);
            this.cameraPredicate = cameraPredicate;
            this.exposurePredicate = exposurePredicate;
            this.locationPredicate = locationPredicate;
        }

        public boolean matches(ServerPlayer player, ItemAndStack<CameraItem> camera, CompoundTag frame, List<Entity> entitiesInFrame) {
            return this.cameraPredicate.matches(camera) && this.exposurePredicate.matches(player, frame, entitiesInFrame) && this.locationPredicate.m_52617_(player.m_284548_(), player.m_20185_(), player.m_20186_(), player.m_20189_());
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext conditions) {
            JsonObject jsonobject = super.m_7683_(conditions);
            jsonobject.add("camera", this.cameraPredicate.serializeToJson());
            jsonobject.add("exposure", this.exposurePredicate.serializeToJson());
            jsonobject.add("location", this.locationPredicate.m_52616_());
            return jsonobject;
        }
    }
}

