/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.etcetera.block;

import com.ninni.etcetera.registry.EtceteraSoundEvents;
import com.ninni.etcetera.registry.EtceteraStats;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DiceBlock
extends DirectionalBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public DiceBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        this.trigger(state, world, pos);
        player.m_36220_((ResourceLocation)EtceteraStats.ROTATE_DICE.get());
        return InteractionResult.SUCCESS;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        boolean powered = world.m_276867_(pos);
        boolean bl2 = (Boolean)state.m_61143_((Property)POWERED);
        if (powered && !bl2) {
            world.m_186460_(pos, (Block)this, 4);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!powered && bl2) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.trigger(state, (Level)world, pos);
    }

    public void trigger(BlockState state, Level world, BlockPos pos) {
        Direction[] directions = Direction.values();
        if (!world.f_46443_) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)FACING, (Comparable)directions[world.m_213780_().m_188503_(directions.length)]));
        }
        world.m_5594_(null, pos, (SoundEvent)EtceteraSoundEvents.BLOCK_DICE_ROLL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static int calculateComparatorOutput(BlockState state) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.UP -> 1;
            case Direction.DOWN -> 6;
            case Direction.NORTH -> 3;
            case Direction.SOUTH -> 4;
            case Direction.EAST -> 2;
            default -> 5;
        };
    }

    public boolean m_7278_(BlockState p_60457_) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return DiceBlock.calculateComparatorOutput(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED});
    }
}

