/*
 * Decompiled with CFR 0.152.
 */
package com.cicada.longwings.networking;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class BookmarkPageC2SPacket {
    private final byte bookmarkedPage;
    private final boolean openMainHand;
    private final boolean bookmarked;

    public BookmarkPageC2SPacket(byte bookmarkedPage, boolean openMainHand, boolean bookmarked) {
        this.bookmarkedPage = bookmarkedPage;
        this.openMainHand = openMainHand;
        this.bookmarked = bookmarked;
    }

    public BookmarkPageC2SPacket(FriendlyByteBuf buf) {
        this(buf.readByte(), buf.readBoolean(), buf.readBoolean());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeByte((int)this.bookmarkedPage);
        buf.writeBoolean(this.openMainHand);
        buf.writeBoolean(this.bookmarked);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            InteractionHand hand = player.m_7655_();
            ItemStack stack = player.m_21120_(this.openMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            if (this.bookmarked) {
                stack.m_41784_().m_128359_("bookmarked", "true");
                stack.m_41784_().m_128344_("page", this.bookmarkedPage);
            } else {
                stack.m_41783_().m_128473_("bookmarked");
                stack.m_41783_().m_128473_("page");
            }
        });
        return true;
    }
}

