/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.flower.functional.BergamuteBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.HornItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.mixin.LivingEntityAccessor;
import vazkii.botania.mixin.MushroomCowAccessor;

public class DrumBlock
extends BotaniaWaterloggedBlock {
    public static final int MAX_NUM_SHEARED = 4;
    public static final int GATHER_RANGE = 10;
    public static final int MINIMUM_REMAINING_EGG_TIME = 600;
    public static final int STARTLED_EGG_TIME = 200;
    private static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private final Variant variant;

    public DrumBlock(Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public static void gatherProduce(Level world, BlockPos pos) {
        List mobs = world.m_6443_(Mob.class, new AABB(pos.m_7918_(-10, -10, -10), pos.m_7918_(11, 11, 11)), mob -> mob.m_6084_() && !BergamuteBlockEntity.isBergamuteNearby(world, mob.m_20185_(), mob.m_20186_(), mob.m_20189_()));
        ArrayList<Shearable> shearables = new ArrayList<Shearable>();
        for (Mob mob2 : mobs) {
            MushroomCow mooshroom;
            Chicken chicken;
            if (mob2 instanceof Chicken && !(chicken = (Chicken)mob2).m_6162_() && !chicken.m_28264_()) {
                DrumBlock.speedUpEggLaying(chicken);
            }
            if (mob2.m_6095_().m_204039_(BotaniaTags.Entities.DRUM_MILKABLE) && !mob2.m_6162_()) {
                DrumBlock.convertNearby(mob2, Items.f_42446_, Items.f_42455_);
            }
            if (mob2 instanceof MushroomCow && !(mooshroom = (MushroomCow)mob2).m_6162_()) {
                if (mooshroom.m_28554_() == MushroomCow.MushroomType.BROWN && ((MushroomCowAccessor)mooshroom).getEffect() != null) {
                    DrumBlock.fillBowlSuspiciously(mooshroom);
                }
                DrumBlock.convertNearby(mob2, Items.f_42399_, Items.f_42400_);
            }
            if (!(mob2 instanceof Shearable)) continue;
            Shearable shearable = (Shearable)mob2;
            if (mob2.m_6095_().m_204039_(BotaniaTags.Entities.DRUM_NO_SHEARING) || !shearable.m_6220_()) continue;
            shearables.add(shearable);
        }
        Collections.shuffle(shearables);
        int sheared = 0;
        for (Shearable shearable : shearables) {
            if (sheared > 4) break;
            shearable.m_5851_(SoundSource.BLOCKS);
            ++sheared;
        }
    }

    private static void speedUpEggLaying(Chicken chicken) {
        if (chicken.f_28231_ > 600) {
            chicken.f_28231_ = Math.max(600, chicken.f_28231_ / 2);
        } else if (chicken.f_28231_ < 200 && chicken.f_28231_ > 1) {
            chicken.f_28231_ = 1;
            ((LivingEntityAccessor)chicken).botania_playHurtSound(chicken.m_269291_().m_269425_());
        }
    }

    private static void convertNearby(Mob mob, Item from, Item to) {
        Level world = mob.m_9236_();
        List fromEntities = world.m_6443_(ItemEntity.class, mob.m_20191_(), itemEntity -> itemEntity.m_6084_() && itemEntity.m_32055_().m_150930_(from));
        for (ItemEntity fromEntity : fromEntities) {
            ItemStack fromStack = fromEntity.m_32055_();
            for (int i = fromStack.m_41613_(); i > 0; --i) {
                DrumBlock.spawnItem(mob, new ItemStack((ItemLike)to));
            }
            fromEntity.m_146870_();
        }
    }

    private static void spawnItem(Mob mob, ItemStack to) {
        Level world = mob.m_9236_();
        ItemEntity ent = mob.m_5552_(to, 1.0f);
        ent.m_20256_(ent.m_20184_().m_82520_((double)(world.f_46441_.m_188501_() * 0.05f), (double)((world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.1f), (double)((world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.1f)));
    }

    private static void fillBowlSuspiciously(MushroomCow mushroomCow) {
        block1: {
            MushroomCowAccessor mushroomCowAccessor = (MushroomCowAccessor)mushroomCow;
            MobEffect effect = mushroomCowAccessor.getEffect();
            int effectDuration = mushroomCowAccessor.getEffectDuration();
            Level world = mushroomCow.m_9236_();
            List bowlItemEntities = world.m_6443_(ItemEntity.class, mushroomCow.m_20191_(), itemEntity -> itemEntity.m_32055_().m_150930_(Items.f_42399_) && !itemEntity.m_32055_().m_41619_());
            Iterator iterator = bowlItemEntities.iterator();
            if (!iterator.hasNext()) break block1;
            ItemEntity bowlItemEntity = (ItemEntity)iterator.next();
            ItemStack bowlItem = bowlItemEntity.m_32055_();
            ItemStack stewItem = new ItemStack((ItemLike)Items.f_42718_);
            SuspiciousStewItem.m_43258_((ItemStack)stewItem, (MobEffect)effect, (int)effectDuration);
            DrumBlock.spawnItem((Mob)mushroomCow, stewItem);
            EntityHelper.shrinkItem(bowlItemEntity);
            if (bowlItem.m_41613_() == 0) {
                bowlItemEntity.m_146870_();
            }
            mushroomCowAccessor.setEffect(null);
            mushroomCowAccessor.setEffectDuration(0);
        }
    }

    public static enum Variant {
        WILD,
        GATHERING,
        CANOPY;

    }

    public static class ManaTriggerImpl
    implements ManaTrigger {
        private final Level world;
        private final BlockPos pos;
        private final Variant variant;

        public ManaTriggerImpl(Level world, BlockPos pos, BlockState state) {
            this.world = world;
            this.pos = pos;
            this.variant = ((DrumBlock)state.m_60734_()).variant;
        }

        @Override
        public void onBurstCollision(ManaBurst burst) {
            if (burst.isFake()) {
                return;
            }
            if (this.world.f_46443_) {
                this.world.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 1.2, (double)this.pos.m_123343_() + 0.5, 0.041666666666666664, 0.0, 0.0);
                return;
            }
            switch (this.variant) {
                case WILD: {
                    HornItem.breakGrass(this.world, new ItemStack((ItemLike)BotaniaItems.grassHorn), this.pos, null);
                    break;
                }
                case CANOPY: {
                    HornItem.breakGrass(this.world, new ItemStack((ItemLike)BotaniaItems.leavesHorn), this.pos, null);
                    break;
                }
                case GATHERING: {
                    DrumBlock.gatherProduce(this.world, this.pos);
                }
            }
            for (int i = 0; i < 10; ++i) {
                this.world.m_5594_(null, this.pos, BotaniaSounds.drum, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
}

