/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.advancements.AlfheimPortalBreadTrigger;
import vazkii.botania.common.advancements.AlfheimPortalTrigger;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.block_entity.PylonBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.api.TriPredicate;

public class AlfheimPortalBlockEntity
extends BotaniaBlockEntity
implements Wandable {
    public static final Supplier<IMultiblock> MULTIBLOCK = Suppliers.memoize(() -> {
        record 1Matcher(TagKey<Block> tag, Direction.Axis displayedRotation, Block defaultBlock) implements IStateMatcher
        {
            public BlockState getDisplayedState(long ticks) {
                List<Block> blocks = StreamSupport.stream(BuiltInRegistries.f_256975_.m_206058_(this.tag).spliterator(), false).map(Holder::m_203334_).toList();
                if (blocks.isEmpty()) {
                    return Blocks.f_50752_.m_49966_();
                }
                BlockState block = blocks.contains(this.defaultBlock) ? this.defaultBlock.m_49966_() : blocks.get((int)(ticks / 20L % (long)blocks.size())).m_49966_();
                return block.m_61138_((Property)BlockStateProperties.f_61365_) ? (BlockState)block.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)this.displayedRotation()) : block;
            }

            public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
                return (blockGetter, pos, state) -> state.m_204336_(this.tag());
            }
        }
        1Matcher horizontal = new 1Matcher(BotaniaTags.Blocks.LIVINGWOOD_LOGS, Direction.Axis.X, BotaniaBlocks.livingwoodLog);
        1Matcher vertical = new 1Matcher(BotaniaTags.Blocks.LIVINGWOOD_LOGS, Direction.Axis.Y, BotaniaBlocks.livingwoodLog);
        1Matcher horizontalGlimmer = new 1Matcher(BotaniaTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING, Direction.Axis.X, BotaniaBlocks.livingwoodLogGlimmering);
        1Matcher verticalGlimmer = new 1Matcher(BotaniaTags.Blocks.LIVINGWOOD_LOGS_GLIMMERING, Direction.Axis.Y, BotaniaBlocks.livingwoodLogGlimmering);
        return PatchouliAPI.get().makeMultiblock((String[][])new String[][]{{"_", "w", "g", "w", "_"}, {"W", " ", " ", " ", "W"}, {"G", " ", " ", " ", "G"}, {"W", " ", " ", " ", "W"}, {"_", "w", "0", "w", "_"}}, new Object[]{Character.valueOf('W'), vertical, Character.valueOf('w'), horizontal, Character.valueOf('G'), verticalGlimmer, Character.valueOf('g'), horizontalGlimmer, Character.valueOf('0'), BotaniaBlocks.alfPortal});
    });
    public static final int MANA_COST = 500;
    public static final int MANA_COST_OPENING = 200000;
    public static final int MIN_REQUIRED_PYLONS = 2;
    private static final String TAG_TICKS_OPEN = "ticksOpen";
    private static final String TAG_TICKS_SINCE_LAST_ITEM = "ticksSinceLastItem";
    private static final String TAG_STACK_COUNT = "stackCount";
    private static final String TAG_STACK = "portalStack";
    private final List<ItemStack> stacksIn = new ArrayList<ItemStack>();
    private final List<BlockPos> cachedPylonPositions = new ArrayList<BlockPos>();
    public int ticksOpen = 0;
    private int ticksSinceLastItem = 0;
    private boolean closeNow = false;
    private boolean explode = false;
    @Nullable
    private UUID breadPlayer = null;

    public AlfheimPortalBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.ALF_PORTAL, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState blockState, AlfheimPortalBlockEntity self) {
        AlfheimPortalState state = (AlfheimPortalState)((Object)blockState.m_61143_(BotaniaStateProperties.ALFPORTAL_STATE));
        if (state == AlfheimPortalState.OFF) {
            self.ticksOpen = 0;
            return;
        }
        AlfheimPortalState newState = self.getValidState(state);
        ++self.ticksOpen;
        AABB aabb = self.getPortalAABB(state);
        boolean open = self.ticksOpen > 60;
        XplatAbstractions.INSTANCE.fireElvenPortalUpdateEvent(self, aabb, open, self.stacksIn);
        if (self.ticksOpen > 60) {
            ++self.ticksSinceLastItem;
            if (level.f_46443_ && BotaniaConfig.client().elfPortalParticlesEnabled()) {
                self.blockParticle(state);
            }
            List items = level.m_45976_(ItemEntity.class, aabb);
            if (!level.f_46443_) {
                for (ItemEntity item : items) {
                    if (!item.m_6084_()) continue;
                    ItemStack stack = item.m_32055_();
                    if (XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).elvenPortalSpawned) continue;
                    item.m_146870_();
                    if (self.validateItemUsage(item)) {
                        self.addItem(stack);
                    }
                    self.ticksSinceLastItem = 0;
                }
            }
            if (!level.f_46443_ && !self.stacksIn.isEmpty() && self.ticksSinceLastItem >= 4) {
                self.resolveRecipes();
            }
        }
        if (self.closeNow) {
            if (!level.f_46443_) {
                level.m_46597_(worldPosition, BotaniaBlocks.alfPortal.m_49966_());
            }
            for (int i = 0; i < 36; ++i) {
                self.blockParticle(state);
            }
            self.closeNow = false;
        } else if (newState != state) {
            if (newState == AlfheimPortalState.OFF) {
                for (int i = 0; i < 36; ++i) {
                    self.blockParticle(state);
                }
            }
            if (!level.f_46443_) {
                level.m_46597_(worldPosition, (BlockState)blockState.m_61124_(BotaniaStateProperties.ALFPORTAL_STATE, (Comparable)((Object)newState)));
            }
        } else if (self.explode) {
            Player entity;
            level.m_254849_(null, (double)worldPosition.m_123341_() + 0.5, (double)worldPosition.m_123342_() + 2.0, (double)worldPosition.m_123343_() + 0.5, 3.0f, Level.ExplosionInteraction.TNT);
            self.explode = false;
            if (!level.f_46443_ && self.breadPlayer != null && (entity = level.m_46003_(self.breadPlayer)) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                AlfheimPortalBreadTrigger.INSTANCE.trigger(serverPlayer, worldPosition);
            }
            self.breadPlayer = null;
        }
    }

    private boolean validateItemUsage(ItemEntity entity) {
        ItemStack inputStack = entity.m_32055_();
        for (Recipe recipe : BotaniaRecipeTypes.getRecipes(this.f_58857_, BotaniaRecipeTypes.ELVEN_TRADE_TYPE).values()) {
            ElvenTradeRecipe tradeRecipe;
            if (!(recipe instanceof ElvenTradeRecipe) || !(tradeRecipe = (ElvenTradeRecipe)recipe).containsItem(inputStack)) continue;
            return true;
        }
        if (inputStack.m_150930_(Items.f_42406_)) {
            this.explode = true;
            if (entity.m_19749_() != null) {
                this.breadPlayer = entity.m_19749_().m_20148_();
            }
        }
        return false;
    }

    private void blockParticle(AlfheimPortalState state) {
        int rnd = this.f_58857_.f_46441_.m_188503_(9);
        double dh = rnd / 3 - 1;
        double dy = rnd % 3 + 1;
        double dx = state == AlfheimPortalState.ON_X ? 0.0 : dh;
        double dz = state == AlfheimPortalState.ON_Z ? 0.0 : dh;
        float motionMul = 0.2f;
        WispParticleData data = WispParticleData.wisp((float)(Math.random() * (double)0.15f + (double)0.1f), (float)(Math.random() * 0.25), (float)(Math.random() * 0.5 + 0.5), (float)(Math.random() * 0.25));
        this.f_58857_.m_7106_((ParticleOptions)data, (double)this.m_58899_().m_123341_() + dx, (double)this.m_58899_().m_123342_() + dy, (double)this.m_58899_().m_123343_() + dz, (double)((float)(Math.random() - 0.5) * motionMul), (double)((float)(Math.random() - 0.5) * motionMul), (double)((float)(Math.random() - 0.5) * motionMul));
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        AlfheimPortalState newState;
        AlfheimPortalState state = (AlfheimPortalState)((Object)this.m_58900_().m_61143_(BotaniaStateProperties.ALFPORTAL_STATE));
        if (state == AlfheimPortalState.OFF && (newState = this.getValidState(state)) != AlfheimPortalState.OFF) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(BotaniaStateProperties.ALFPORTAL_STATE, (Comparable)((Object)newState)));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AlfheimPortalTrigger.INSTANCE.trigger(serverPlayer, serverPlayer.m_284548_(), this.m_58899_(), stack);
            }
            return true;
        }
        return false;
    }

    private AABB getPortalAABB(AlfheimPortalState state) {
        return state == AlfheimPortalState.ON_X ? new AABB(this.f_58858_.m_7918_(0, 1, -1), this.f_58858_.m_7918_(1, 4, 2)) : new AABB(this.f_58858_.m_7918_(-1, 1, 0), this.f_58858_.m_7918_(2, 4, 1));
    }

    private void addItem(ItemStack stack) {
        int size = stack.m_41613_();
        stack.m_41764_(1);
        for (int i = 0; i < size; ++i) {
            this.stacksIn.add(stack.m_41777_());
        }
    }

    public static Collection<ElvenTradeRecipe> elvenTradeRecipes(Level world) {
        return BotaniaRecipeTypes.getRecipes(world, BotaniaRecipeTypes.ELVEN_TRADE_TYPE).values();
    }

    private void resolveRecipes() {
        List<BlockPos> pylons = this.locatePylons(true);
        for (Recipe recipe : BotaniaRecipeTypes.getRecipes(this.f_58857_, BotaniaRecipeTypes.ELVEN_TRADE_TYPE).values()) {
            ElvenTradeRecipe recipe2;
            Optional<List<ItemStack>> match;
            if (!(recipe instanceof ElvenTradeRecipe) || !(match = (recipe2 = (ElvenTradeRecipe)recipe).match(this.stacksIn)).isPresent()) continue;
            if (!this.consumeMana(pylons, 500, false)) break;
            List<ItemStack> inputs = match.get();
            for (ItemStack stack : inputs) {
                this.stacksIn.remove(stack);
            }
            for (ItemStack output : recipe2.getOutputs(inputs)) {
                this.spawnItem(output.m_41777_());
            }
        }
    }

    private void spawnItem(ItemStack stack) {
        ItemEntity item = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, stack);
        XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).elvenPortalSpawned = true;
        this.f_58857_.m_7967_((Entity)item);
        this.ticksSinceLastItem = 0;
    }

    @Override
    public void m_183515_(CompoundTag cmp) {
        super.m_183515_(cmp);
        cmp.m_128405_(TAG_STACK_COUNT, this.stacksIn.size());
        int i = 0;
        for (ItemStack stack : this.stacksIn) {
            CompoundTag stackcmp = stack.m_41739_(new CompoundTag());
            cmp.m_128365_(TAG_STACK + i, (Tag)stackcmp);
            ++i;
        }
    }

    @Override
    public void m_142466_(@NotNull CompoundTag cmp) {
        super.m_142466_(cmp);
        int count = cmp.m_128451_(TAG_STACK_COUNT);
        this.stacksIn.clear();
        for (int i = 0; i < count; ++i) {
            CompoundTag stackcmp = cmp.m_128469_(TAG_STACK + i);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)stackcmp);
            this.stacksIn.add(stack);
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_TICKS_OPEN, this.ticksOpen);
        cmp.m_128405_(TAG_TICKS_SINCE_LAST_ITEM, this.ticksSinceLastItem);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.ticksOpen = cmp.m_128451_(TAG_TICKS_OPEN);
        this.ticksSinceLastItem = cmp.m_128451_(TAG_TICKS_SINCE_LAST_ITEM);
    }

    private static Rotation getStateRotation(AlfheimPortalState state) {
        return switch (state) {
            case AlfheimPortalState.ON_X -> Rotation.CLOCKWISE_90;
            case AlfheimPortalState.ON_Z -> Rotation.NONE;
            default -> null;
        };
    }

    private AlfheimPortalState getValidState(AlfheimPortalState oldState) {
        Rotation rot;
        if (oldState != AlfheimPortalState.OFF) {
            Rotation oldRot = AlfheimPortalBlockEntity.getStateRotation(oldState);
            if (!MULTIBLOCK.get().validate(this.f_58857_, this.m_58899_(), oldRot)) {
                return AlfheimPortalState.OFF;
            }
            rot = oldRot;
        } else {
            rot = MULTIBLOCK.get().validate(this.f_58857_, this.m_58899_());
        }
        if (rot == null) {
            return AlfheimPortalState.OFF;
        }
        this.lightPylons();
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE, Rotation.CLOCKWISE_180 -> AlfheimPortalState.ON_Z;
            case Rotation.CLOCKWISE_90, Rotation.COUNTERCLOCKWISE_90 -> AlfheimPortalState.ON_X;
        };
    }

    public List<BlockPos> locatePylons(boolean rescanNow) {
        if (!rescanNow && this.cachedPylonPositions.size() >= 2) {
            ArrayList<BlockPos> cachedResult = new ArrayList<BlockPos>();
            for (BlockPos pos : this.cachedPylonPositions) {
                if (!this.isValidPylonPosition(pos)) continue;
                cachedResult.add(pos);
            }
            if (cachedResult.size() >= 2) {
                return cachedResult;
            }
        }
        int range = 5;
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.m_58899_().m_7918_(-range, -range, -range), (BlockPos)this.m_58899_().m_7918_(range, range, range))) {
            if (!this.isValidPylonPosition(pos)) continue;
            result.add(pos.m_7949_());
        }
        this.cachedPylonPositions.clear();
        this.cachedPylonPositions.addAll(result);
        return result;
    }

    private boolean isValidPylonPosition(BlockPos pos) {
        return this.m_58904_().m_46805_(pos) && this.m_58904_().m_8055_(pos).m_60713_(BotaniaBlocks.naturaPylon) && this.m_58904_().m_8055_(pos.m_7495_()).m_60734_() instanceof ManaPoolBlock;
    }

    public void lightPylons() {
        if (this.ticksOpen < 50) {
            return;
        }
        boolean finishOpening = this.ticksOpen == 50;
        List<BlockPos> pylons = this.locatePylons(finishOpening);
        for (BlockPos pos : pylons) {
            BlockEntity tile = this.f_58857_.m_7702_(pos);
            if (!(tile instanceof PylonBlockEntity)) continue;
            PylonBlockEntity pylon = (PylonBlockEntity)tile;
            pylon.activated = true;
            pylon.centerPos = this.m_58899_();
        }
        if (finishOpening) {
            this.consumeMana(pylons, 200000, true);
        }
    }

    public boolean consumeMana(List<BlockPos> pylons, int totalCost, boolean close) {
        ArrayList<ManaPoolBlockEntity> consumePools = new ArrayList<ManaPoolBlockEntity>();
        int consumed = 0;
        if (pylons.size() < 2) {
            this.closeNow = true;
            return false;
        }
        int costPer = Math.max(1, totalCost / pylons.size());
        int expectedConsumption = costPer * pylons.size();
        for (BlockPos pos : pylons) {
            BlockEntity tile = this.f_58857_.m_7702_(pos);
            if (tile instanceof PylonBlockEntity) {
                PylonBlockEntity pylon = (PylonBlockEntity)tile;
                pylon.activated = true;
                pylon.centerPos = this.m_58899_();
            }
            if (!((tile = this.f_58857_.m_7702_(pos.m_7495_())) instanceof ManaPoolBlockEntity)) continue;
            ManaPoolBlockEntity pool = (ManaPoolBlockEntity)tile;
            if (pool.getCurrentMana() < costPer) {
                this.closeNow = this.closeNow || close;
                return false;
            }
            if (this.f_58857_.f_46443_) continue;
            consumePools.add(pool);
            consumed += costPer;
        }
        if (consumed >= expectedConsumption) {
            for (ManaPoolBlockEntity pool : consumePools) {
                pool.receiveMana(-costPer);
                pool.craftingEffect(false);
            }
            return true;
        }
        return false;
    }
}

