/*
 * Decompiled with CFR 0.152.
 */
package net.ribs.vintagedelight.compat;

import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.ribs.vintagedelight.block.ModBlocks;
import net.ribs.vintagedelight.recipe.FermentingRecipe;

public class FermentingCategory
implements IRecipeCategory<FermentingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("vintagedelight", "fermenting");
    public static final ResourceLocation TEXTURE = new ResourceLocation("vintagedelight", "textures/gui/fermenting_jar_gui.png");
    public static final RecipeType<FermentingRecipe> FERMENTING_TYPE = new RecipeType(UID, FermentingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final int offsetX = 10;
    private final int offsetY = 10;

    public FermentingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 10, 10, 154, 65);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.FERMENTING_JAR.get()));
    }

    public RecipeType<FermentingRecipe> getRecipeType() {
        return FERMENTING_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"block.vintagedelight.fermenting_jar");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FermentingRecipe recipe, IFocusGroup focuses) {
        int inputBaseX = 6;
        int firstRowY = 7;
        int secondRowY = firstRowY + 18;
        int inputSpacing = 18;
        int outputOffsetX = 90;
        int secondaryOutputX = outputOffsetX + inputSpacing;
        int additionalSpacing = 2;
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            int row = i / 3;
            int col = i % 3;
            int x = inputBaseX + col * inputSpacing + 10;
            int y = row == 0 ? firstRowY + 10 : secondRowY + 10;
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients((Ingredient)recipe.m_7527_().get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, inputBaseX + outputOffsetX + 10, secondRowY + 10).addItemStack(recipe.m_8043_(null));
        if (!recipe.getSecondaryResultItem().m_41619_()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, inputBaseX + secondaryOutputX + 10, secondRowY + 10).addItemStack(recipe.getSecondaryResultItem());
        }
        int containerSlotX = inputBaseX + 2 * inputSpacing + inputSpacing + additionalSpacing + 10;
        int containerSlotY = firstRowY + 10;
        ItemStack containerItemStack = recipe.getContainerItemStack();
        if (!containerItemStack.m_41619_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, containerSlotX, containerSlotY).addItemStack(containerItemStack);
        }
    }

    public void draw(FermentingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        int processingTime = recipe.getProcessingTime();
        if (processingTime > 0) {
            int minutes = processingTime / 1200;
            String processingTimeText = String.format("%dmin", minutes);
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, processingTimeText, 110, 20, Color.gray.getRGB(), false);
        }
    }
}

