/*
 * Decompiled with CFR 0.152.
 */
package net.ribs.vintagedelight.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.ribs.vintagedelight.block.entity.FermentingJarBlockEntity;

public class FermentingJarBlockEntityRenderer
implements BlockEntityRenderer<FermentingJarBlockEntity> {
    private final Random random = new Random();
    private final Map<ItemStack, Float> itemRotations = new HashMap<ItemStack, Float>();
    private final float maxRotationIncrement = 360.0f;

    public FermentingJarBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FermentingJarBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        List<ItemStack> itemStacks = pBlockEntity.getRenderStacks();
        float baseHeight = 0.15f;
        float heightIncrement = 0.06f;
        for (ItemStack stack : itemStacks) {
            this.itemRotations.computeIfAbsent(stack, k -> Float.valueOf(this.random.nextFloat() * 360.0f));
            float rotationAngle = this.itemRotations.get(stack).floatValue();
            pPoseStack.m_85836_();
            pPoseStack.m_252880_(0.5f, baseHeight, 0.5f);
            pPoseStack.m_85841_(0.4f, 0.4f, 0.4f);
            pPoseStack.m_252781_(Axis.f_252529_.m_252977_(270.0f));
            pPoseStack.m_252781_(Axis.f_252403_.m_252977_(rotationAngle));
            itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, this.getLightLevel(pBlockEntity.m_58904_(), pBlockEntity.m_58899_()), OverlayTexture.f_118083_, pPoseStack, pBuffer, pBlockEntity.m_58904_(), 1);
            pPoseStack.m_85849_();
            baseHeight += heightIncrement;
        }
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.m_45517_(LightLayer.BLOCK, pos);
        int sLight = level.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)bLight, (int)sLight);
    }
}

