/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.satisfy.wildernature.util.contract.ContractReloader;

public record BountyBoardTier(int experience, Optional<ResourceLocation> nextTier, Optional<ResourceLocation> previousTier) {
    public static final Codec<BountyBoardTier> CODEC = RecordCodecBuilder.create(bountyBoardTierInstance -> bountyBoardTierInstance.group((App)Codec.INT.fieldOf("experience").forGetter(BountyBoardTier::experience), (App)ResourceLocation.f_135803_.optionalFieldOf("nextTier").forGetter(BountyBoardTier::nextTier), (App)ResourceLocation.f_135803_.optionalFieldOf("previousTier").forGetter(BountyBoardTier::previousTier)).apply((Applicative)bountyBoardTierInstance, BountyBoardTier::new));

    public float progress(int xp) {
        return this.experience == -1 ? 1.0f : (float)xp / (float)(this.experience - 1);
    }

    public static Optional<BountyBoardTier> byId(ResourceLocation id) {
        return Optional.ofNullable(ContractReloader.tiers.get(id));
    }
}

