/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.network;

import dev.architectury.networking.NetworkManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.satisfy.wildernature.client.gui.handlers.BountyBlockScreenHandler;
import net.satisfy.wildernature.util.WilderNatureIdentifier;

public class BountyBlockNetworking {
    public static final ResourceLocation ID_SCREEN_UPDATE = new WilderNatureIdentifier("screen_update");
    public static final ResourceLocation ID_SCREEN_ACTION = new WilderNatureIdentifier("screen_action");
    public static final int MAX_SIZE = 32768;

    static void handleServerUpdate(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BountyBlockScreenHandler) {
            BountyBlockScreenHandler screenHandler = (BountyBlockScreenHandler)abstractContainerMenu;
            screenHandler.onServerUpdate(buf);
        }
    }

    static void handleClientAction(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof BountyBlockScreenHandler) {
            BountyBlockScreenHandler screenHandler = (BountyBlockScreenHandler)abstractContainerMenu;
            screenHandler.handleClientAction((ServerPlayer)player, buf);
        }
    }

    public static void register() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)ID_SCREEN_UPDATE, (buf, context) -> {
            Player player = context.getPlayer();
            AbstractContainerMenu patt1866$temp = player.f_36096_;
            if (patt1866$temp instanceof BountyBlockScreenHandler) {
                BountyBlockScreenHandler screenHandler = (BountyBlockScreenHandler)patt1866$temp;
                screenHandler.onServerUpdate(buf);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)ID_SCREEN_ACTION, (buf, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            AbstractContainerMenu patt2207$temp = player.f_36096_;
            if (patt2207$temp instanceof BountyBlockScreenHandler) {
                BountyBlockScreenHandler screenHandler = (BountyBlockScreenHandler)patt2207$temp;
                screenHandler.handleClientAction(player, buf);
            }
        });
    }

    public static enum BountyClientActionType {
        REROLL,
        CONFIRM_CONTRACT,
        FINISH_CONTRACT,
        DELETE_CONTRACT;

    }

    public static enum BountyServerUpdateType {
        SEND_BOARD_DATA,
        UPDATE_CONTRACTS,
        SET_ACTIVE_CONTRACT,
        CLEAR_ACTIVE_CONTRACT,
        MULTI;

    }
}

