/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.wildernature.entity.RaccoonEntity;
import net.satisfy.wildernature.entity.animation.RaccoonAnimation;
import net.satisfy.wildernature.util.WilderNatureIdentifier;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class RaccoonModel<T extends RaccoonEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation((ResourceLocation)new WilderNatureIdentifier("raccoon"), "main");
    private final ModelPart root;

    public RaccoonModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)0.5f));
        PartDefinition animroot = root.m_171599_("animroot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = animroot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-4.0f, -5.5f, -3.0f, 8.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-0.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -4.0f, -6.0f, 10.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 13).m_171488_(-4.0f, -6.0f, -2.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(2.0f, -6.0f, -2.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(22, 13).m_171488_(-2.0f, 0.0f, -9.0f, 4.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.5f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(22, 24).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)5.5f, (float)0.0f));
        PartDefinition leftHindLeg = animroot.m_171599_("leftHindLeg", CubeListBuilder.m_171558_().m_171514_(8, 30).m_171488_(-0.005f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)0.0f, (float)3.0f));
        PartDefinition rightHindLeg = animroot.m_171599_("rightHindLeg", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(0.005f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)0.0f, (float)3.0f));
        PartDefinition leftFrontLeg = animroot.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(8, 30).m_171488_(-1.005f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)-4.0f));
        PartDefinition rightFrontLeg = animroot.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171488_(-0.995f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)-4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T raccoon, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (((RaccoonEntity)((Object)raccoon)).isRaccoonRunning()) {
            this.m_267799_(RaccoonAnimation.run, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        } else {
            this.m_267799_(RaccoonAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        }
        this.m_233385_(((RaccoonEntity)((Object)raccoon)).openDoorState, RaccoonAnimation.opening_door, ageInTicks, 1.0f);
        this.m_233385_(((RaccoonEntity)((Object)raccoon)).washingState, RaccoonAnimation.wash, ageInTicks, 1.0f);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }
}

