/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.wildernature.entity.MiniSheepEntity;
import net.satisfy.wildernature.entity.animation.MiniSheepAnimation;
import net.satisfy.wildernature.util.WilderNatureIdentifier;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MiniSheepModel<T extends MiniSheepEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation((ResourceLocation)new WilderNatureIdentifier("minisheep"), "main");
    private final ModelPart mini_sheep;
    private final ModelPart head;

    public MiniSheepModel(ModelPart root) {
        this.mini_sheep = root.m_171324_("mini_sheep");
        this.head = this.mini_sheep.m_171324_("head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition mini_sheep = partdefinition.m_171599_("mini_sheep", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition head = mini_sheep.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.24f, (float)-7.04f));
        PartDefinition h_horn = head.m_171599_("h_horn", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.24f, (float)-2.16f, (float)-0.48f));
        PartDefinition cube_r1 = h_horn.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(39, 9).m_171480_().m_171488_(-1.44f, -0.6f, -4.32f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(39, 9).m_171488_(-8.24f, -0.6f, -4.32f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.08f, (float)-2.4f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition h_ear = head.m_171599_("h_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.48f, (float)-1.68f, (float)-1.92f));
        PartDefinition right_ear = h_ear.m_171599_("right_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.84f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = right_ear.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(28, 27).m_171488_(-7.22f, -1.48f, -0.04f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.4f, (float)5.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition left_ear = h_ear.m_171599_("left_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.8f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = left_ear.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(28, 27).m_171480_().m_171488_(4.22f, -1.48f, -0.04f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.4f, (float)5.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition h_head2 = head.m_171599_("h_head2", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171480_().m_171488_(-3.0f, -2.2f, -3.84f, 6.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-1.2f, (float)0.0f));
        PartDefinition cube_r4 = h_head2.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(17, 27).m_171480_().m_171488_(-2.0f, -4.76f, 0.84f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)7.2f, (float)-4.8f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition body = mini_sheep.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.28f, -5.8f, -7.62f, 12.0f, 12.0f, 15.0f, new CubeDeformation(0.8f)).m_171514_(1, 33).m_171488_(-5.28f, -5.8f, -7.62f, 12.0f, 12.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.72f, (float)-1.0f, (float)1.12f));
        PartDefinition right_front_leg = mini_sheep.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171480_().m_171488_(-1.08f, -0.2f, -1.16f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.6f, (float)5.2f, (float)-4.88f));
        PartDefinition left_front_leg = mini_sheep.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171480_().m_171488_(-1.56f, -0.2f, -1.16f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.6f, (float)5.2f, (float)-4.88f));
        PartDefinition right_hind_leg = mini_sheep.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171480_().m_171488_(-1.08f, -0.2f, -1.2f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.6f, (float)5.2f, (float)6.12f));
        PartDefinition left_hind_leg = mini_sheep.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-1.56f, -0.2f, -2.2f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.6f, (float)5.2f, (float)7.12f));
        PartDefinition tail = mini_sheep.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(4, 2).m_171488_(-0.96f, -0.6f, -1.52f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.12f, (float)1.84f, (float)9.76f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(MiniSheepEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.m_267799_(MiniSheepAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.m_233385_(entity.idleAnimationState, MiniSheepAnimation.idle, ageInTicks, 1.0f);
        this.m_233385_(entity.attackAnimationState, MiniSheepAnimation.attack, ageInTicks, 1.0f);
        this.m_233385_(entity.eatAnimationState, MiniSheepAnimation.eat, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float pNetHeadYaw, float pHeadPitch) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.mini_sheep.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.mini_sheep;
    }
}

