/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.block.entity;

import com.mojang.serialization.DynamicOps;
import dev.architectury.platform.Platform;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.wildernature.client.gui.handlers.BountyBlockScreenHandler;
import net.satisfy.wildernature.event.EventManager;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.util.BountyBoardTier;
import net.satisfy.wildernature.util.WilderNatureIdentifier;
import net.satisfy.wildernature.util.contract.Contract;
import net.satisfy.wildernature.util.contract.ContractReloader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BountyBoardBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final String KEY_CONTRACTS = "contracts";
    private static final int REROLL_COOLDOWN = 18000;
    public int rerollCooldownLeft = 0;
    private static final String KEY_REROLL_COOLDOWN_LEFT = "reroll_cooldown_left";
    public static final int MAX_REROLLS = 3;
    public int rerollsLeft;
    private static final String KEY_REROLLS_LEFT = "rerolls_left";
    private static final String KEY_TIER = "tier";
    private static final String KEY_EXP = "experience";
    private static final String KEY_LONGID = "longid";
    public EventManager onTick = new EventManager();
    public EventManager onBlockDataChange = new EventManager();
    public long boardId = new Random().nextInt();
    private ResourceLocation[] contracts = new ResourceLocation[3];
    public ResourceLocation tier = new WilderNatureIdentifier("tier1");
    public int xp = 0;

    public ResourceLocation[] getContracts() {
        if (this.contracts == null || this.contracts.length != 3) {
            this.contracts = new ResourceLocation[3];
            this.fillWithRandomContracts();
        }
        for (int i = 0; i < 3; ++i) {
            if (this.contracts[i] != null) continue;
            this.contracts[i] = this.getRandomContract();
        }
        return (ResourceLocation[])this.contracts.clone();
    }

    public void setContracts(ResourceLocation[] contracts) {
        this.contracts = (ResourceLocation[])contracts.clone();
    }

    public BountyBoardBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityRegistry.BOUNTY_BOARD_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag compoundTag) {
        this.rerollCooldownLeft = compoundTag.m_128441_(KEY_REROLL_COOLDOWN_LEFT) ? compoundTag.m_128451_(KEY_REROLL_COOLDOWN_LEFT) : 0;
        this.rerollsLeft = compoundTag.m_128441_(KEY_REROLLS_LEFT) ? compoundTag.m_128451_(KEY_REROLLS_LEFT) : 3;
        this.boardId = compoundTag.m_128441_(KEY_LONGID) ? compoundTag.m_128454_(KEY_LONGID) : (long)new Random().nextInt();
        this.tier = compoundTag.m_128441_(KEY_TIER) ? new ResourceLocation(compoundTag.m_128461_(KEY_TIER)) : new WilderNatureIdentifier("");
        int n = this.xp = compoundTag.m_128441_(KEY_EXP) ? compoundTag.m_128451_(KEY_EXP) : 0;
        if (compoundTag.m_128441_(KEY_CONTRACTS)) {
            this.setContracts(((List)ResourceLocation.f_135803_.listOf().parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_(KEY_CONTRACTS)).getOrThrow(false, error -> {
                throw new RuntimeException((String)error);
            })).toArray(new ResourceLocation[3]));
        } else {
            this.fillWithRandomContracts();
        }
    }

    public void tryReroll() {
        if (this.rerollsLeft <= 0) {
            return;
        }
        if (this.rerollsLeft == 3) {
            this.rerollCooldownLeft = 18000;
        }
        --this.rerollsLeft;
        this.fillWithRandomContracts();
        this.onBlockDataChange.invoke();
    }

    private void fillWithRandomContracts() {
        for (int i = 0; i < 3; ++i) {
            this.setRandomContractInSlot(i);
        }
    }

    public void setRandomContractInSlot(int i) {
        ResourceLocation[] contracts = this.getContracts();
        contracts[i] = this.getRandomContract();
        this.setContracts(contracts);
    }

    private ResourceLocation getRandomContract() {
        return ContractReloader.getRandomContractOfTier(this.tier);
    }

    public void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_(KEY_REROLL_COOLDOWN_LEFT, this.rerollCooldownLeft);
        compoundTag.m_128405_(KEY_REROLLS_LEFT, this.rerollsLeft);
        compoundTag.m_128356_(KEY_LONGID, this.boardId);
        compoundTag.m_128359_(KEY_TIER, this.tier.toString());
        compoundTag.m_128405_(KEY_EXP, this.xp);
        compoundTag.m_128365_(KEY_CONTRACTS, (Tag)ResourceLocation.f_135803_.listOf().encode(Arrays.stream(this.getContracts()).toList(), (DynamicOps)NbtOps.f_128958_, (Object)new ListTag()).getOrThrow(false, error -> {
            throw new RuntimeException((String)error);
        }));
    }

    public CompoundTag getContractsNbt() {
        Tag encodedContracts = (Tag)Contract.CODEC.listOf().encode(Arrays.stream(this.getContracts()).map(Contract::fromId).toList(), (DynamicOps)NbtOps.f_128958_, (Object)new ListTag()).getOrThrow(false, error -> {
            throw new RuntimeException((String)error);
        });
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("list", encodedContracts);
        return tag;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return BountyBlockScreenHandler.createServer(id, inventory, this);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BountyBoardBlockEntity entity) {
        entity.serverTick(level, pos, state);
    }

    private void serverTick(Level level, BlockPos pos, BlockState state) {
        --this.rerollCooldownLeft;
        if (this.rerollCooldownLeft < 0) {
            this.rerollsLeft = 3;
        }
        this.onTick.invoke();
    }

    public BountyBoardTier getTier() {
        return BountyBoardTier.byId(this.tier).orElseThrow(() -> new RuntimeException("BountyBoardTier not found for tier: " + this.tier));
    }

    public void addXp(int additionalXp) {
        int nextTierXp = this.getTier().experience();
        this.xp += additionalXp;
        if (this.xp >= nextTierXp) {
            additionalXp = this.xp - nextTierXp;
            this.xp = 0;
            if (this.getTier().nextTier().isEmpty()) {
                if (Platform.isDevelopmentEnvironment()) {
                    Objects.requireNonNull(Objects.requireNonNull(this.m_58904_()).m_7654_()).m_6846_().m_240416_((Component)Component.m_237113_((String)"_info: next tier is empty, impossible to upgrade"), true);
                }
                return;
            }
            this.tier = this.getTier().nextTier().get();
            this.onBlockDataChange.invoke();
            this.addXp(additionalXp);
        }
    }
}

