/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree;

import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.events.ILightningStruckBlockEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.mysticaloaktree.block.WiseOakBlock;
import net.mehvahdjukaar.mysticaloaktree.block.WiseOakTile;
import net.mehvahdjukaar.mysticaloaktree.client.TreeLoreManager;
import net.mehvahdjukaar.mysticaloaktree.worldgen.BiomeMatchPredicate;
import net.mehvahdjukaar.mysticaloaktree.worldgen.WiseOakDecorator;
import net.mehvahdjukaar.mysticaloaktree.worldgen.WiseOakFeature;
import net.mehvahdjukaar.mysticaloaktree.worldgen.WiseOakFoliagePlacer;
import net.mehvahdjukaar.mysticaloaktree.worldgen.WiseOakTrunkPlacer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.PushReaction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MysticalOakTree {
    public static final String MOD_ID = "mysticaloaktree";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Supplier<SimpleParticleType> WIND = RegHelper.registerParticle((ResourceLocation)MysticalOakTree.res("wind"));
    public static final Supplier<Block> BLOCK = RegHelper.registerBlockWithItem((ResourceLocation)MysticalOakTree.res("wise_oak"), () -> new WiseOakBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_278166_(PushReaction.BLOCK).m_60913_(4.0f, 4.0f)), (Item.Properties)new Item.Properties().m_41497_(Rarity.EPIC), (int)1000);
    public static final Supplier<BlockEntityType<WiseOakTile>> TILE = RegHelper.registerBlockEntityType((ResourceLocation)MysticalOakTree.res("wise_oak"), () -> PlatHelper.newBlockEntityType(WiseOakTile::new, (Block[])new Block[]{BLOCK.get()}));
    public static final RegSupplier<BlockPredicateType<BiomeMatchPredicate>> BIOME_MATCH_PREDICATE = RegHelper.register((ResourceLocation)MysticalOakTree.res("biome_match"), () -> () -> BiomeMatchPredicate.CODEC, (ResourceKey)Registries.f_256774_);
    public static final RegSupplier<Feature<WiseOakFeature.Configuration>> WISE_OAK_FEATURE = RegHelper.registerFeature((ResourceLocation)MysticalOakTree.res("wise_oak"), WiseOakFeature::new);
    public static final RegSupplier<TrunkPlacerType<WiseOakTrunkPlacer>> WISE_OAK_TRUNK_PLACER = RegHelper.register((ResourceLocation)MysticalOakTree.res("wise_oak_trunk_placer"), () -> new TrunkPlacerType(WiseOakTrunkPlacer.CODEC), (ResourceKey)Registries.f_256963_);
    public static final RegSupplier<FoliagePlacerType<WiseOakFoliagePlacer>> WISE_OAK_FOLIAGE_PLACER = RegHelper.register((ResourceLocation)MysticalOakTree.res("wise_oak_foliage_placer"), () -> new FoliagePlacerType(WiseOakFoliagePlacer.CODEC), (ResourceKey)Registries.f_256905_);
    public static final RegSupplier<TreeDecoratorType<WiseOakDecorator>> WISE_OAK_DECORATOR = RegHelper.register((ResourceLocation)MysticalOakTree.res("wise_oak_decorator"), () -> new TreeDecoratorType(WiseOakDecorator.CODEC), (ResourceKey)Registries.f_256845_);

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void commonInit() {
        TreeLoreManager.init();
        MoonlightEventsHelper.addListener(MysticalOakTree::onLightningStrike, ILightningStruckBlockEvent.class);
        RegHelper.addItemsToTabsRegistration(event -> {
            event.add(CreativeModeTabs.f_256776_, new ItemLike[]{(ItemLike)BLOCK.get()});
            event.add(CreativeModeTabs.f_256791_, new ItemLike[]{(ItemLike)BLOCK.get()});
        });
    }

    private static void onLightningStrike(ILightningStruckBlockEvent event) {
        BlockPos pos = event.getPos().m_7494_();
        BlockState state = event.getLevel().m_8055_(pos);
        if (state.m_60734_() == Blocks.f_50746_) {
            ServerLevel level = (ServerLevel)event.getLevel();
            BlockState blockState = level.m_6425_(pos).m_76188_();
            level.m_7731_(pos, blockState, 4);
            PlacedFeature feature = (PlacedFeature)((Registry)event.getLevel().m_9598_().m_6632_(Registries.f_256988_).get()).m_7745_(MysticalOakTree.res("wise_oak"));
            if (feature.m_226357_((WorldGenLevel)level, level.m_7726_().m_8481_(), level.f_46441_, pos)) {
                if (level.m_8055_(pos) == blockState) {
                    level.m_7260_(pos, state, blockState, 2);
                }
            } else {
                level.m_7731_(pos, state, 4);
            }
        }
    }
}

