/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TransparentTextField
extends EditBox {
    private Font font;
    private Component label;
    private int labelColor = 0x808080;
    private boolean pseudoIsEnabled = true;
    private boolean pseudoEnableBackgroundDrawing = true;
    private int pseudoMaxStringLength = 32;
    private int pseudoLineScrollOffset;
    private int pseudoEnabledColor = 0xE0E0E0;
    private int pseudoDisabledColor = 0x707070;
    private int pseudoCursorCounter;
    private int pseudoSelectionEnd;

    public TransparentTextField(Font font, int x, int y, int width, int height, Component label) {
        super(font, x, y, width, height, label);
        this.font = font;
        this.label = label;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.m_94213_()) {
            boolean showLabel;
            if (this.pseudoEnableBackgroundDrawing) {
                int color = 140;
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, 0x46000000);
            }
            boolean bl = showLabel = !this.m_93696_() && this.m_94155_().isEmpty();
            int i = showLabel ? this.labelColor : (this.pseudoIsEnabled ? this.pseudoEnabledColor : this.pseudoDisabledColor);
            int j = this.m_94207_() - this.pseudoLineScrollOffset;
            int k = this.pseudoSelectionEnd - this.pseudoLineScrollOffset;
            String text = showLabel ? this.label.getString() : this.m_94155_();
            String s = this.font.m_92834_(text.substring(this.pseudoLineScrollOffset), this.m_5711_());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.m_93696_() && this.pseudoCursorCounter / 6 % 2 == 0 && flag;
            int l = this.pseudoEnableBackgroundDrawing ? this.m_252754_() + 4 : this.m_252754_();
            int i1 = this.pseudoEnableBackgroundDrawing ? this.m_252907_() + (this.f_93619_ - 8) / 2 : this.m_252907_();
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = guiGraphics.m_280056_(this.font, s1, l, i1, i, true);
            }
            boolean flag2 = this.m_94207_() < this.m_94155_().length() || this.m_94155_().length() >= this.pseudoMaxStringLength;
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.f_93618_ : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                j1 = guiGraphics.m_280056_(this.font, s.substring(j), j1, i1, i, true);
            }
            if (flag1) {
                if (flag2) {
                    RenderType renderType = RenderType.m_286086_();
                    Objects.requireNonNull(this.font);
                    guiGraphics.m_285944_(renderType, k1, i1 - 1, k1 + 1, i1 + 1 + 9, -3092272);
                } else {
                    guiGraphics.m_280056_(this.font, "_", k1, i1, i, true);
                }
            }
            if (k != j) {
                int l1 = l + this.font.m_92895_(s.substring(0, k));
                Objects.requireNonNull(this.font);
                this.drawSelectionBox(guiGraphics, k1, i1 - 1, l1 - 1, i1 + 1 + 9);
            }
        }
    }

    public void m_94186_(boolean enabled) {
        super.m_94186_(enabled);
        this.pseudoIsEnabled = enabled;
    }

    public void m_94202_(int color) {
        super.m_94202_(color);
        this.pseudoEnabledColor = color;
    }

    public void m_94205_(int color) {
        super.m_94205_(color);
        this.pseudoDisabledColor = color;
    }

    public void m_93692_(boolean isFocused) {
        if (isFocused && !this.m_93696_()) {
            this.pseudoCursorCounter = 0;
        }
        super.m_93692_(isFocused);
    }

    public void m_94182_(boolean enableBackgroundDrawing) {
        super.m_94182_(enableBackgroundDrawing);
        this.pseudoEnableBackgroundDrawing = enableBackgroundDrawing;
    }

    public void m_94199_(int length) {
        super.m_94199_(length);
        this.pseudoMaxStringLength = length;
    }

    public void m_94120_() {
        super.m_94120_();
        ++this.pseudoCursorCounter;
    }

    public void m_94208_(int position) {
        super.m_94208_(position);
        int i = this.m_94155_().length();
        this.pseudoSelectionEnd = Mth.m_14045_((int)position, (int)0, (int)i);
        if (this.font != null) {
            if (this.pseudoLineScrollOffset > i) {
                this.pseudoLineScrollOffset = i;
            }
            int j = this.m_94210_();
            String s = this.font.m_92837_(this.m_94155_().substring(this.pseudoLineScrollOffset), j, false);
            int k = s.length() + this.pseudoLineScrollOffset;
            if (this.pseudoSelectionEnd == this.pseudoLineScrollOffset) {
                this.pseudoLineScrollOffset -= this.font.m_92837_(this.m_94155_(), j, true).length();
            }
            if (this.pseudoSelectionEnd > k) {
                this.pseudoLineScrollOffset += this.pseudoSelectionEnd - k;
            } else if (this.pseudoSelectionEnd <= this.pseudoLineScrollOffset) {
                this.pseudoLineScrollOffset -= this.pseudoLineScrollOffset - this.pseudoSelectionEnd;
            }
            this.pseudoLineScrollOffset = Mth.m_14045_((int)this.pseudoLineScrollOffset, (int)0, (int)i);
        }
    }

    public void setLabel(Component label) {
        this.label = label;
    }

    public void setLabelColor(int labelColor) {
        this.labelColor = labelColor;
    }

    private void drawSelectionBox(GuiGraphics guiGraphics, int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.m_252754_() + this.f_93618_) {
            endX = this.m_252754_() + this.f_93618_;
        }
        if (startX > this.m_252754_() + this.f_93618_) {
            startX = this.m_252754_() + this.f_93618_;
        }
        guiGraphics.m_285944_(RenderType.m_285783_(), startX, startY, endX, endY, -16776961);
    }
}

