/*
 * Decompiled with CFR 0.152.
 */
package me.litchi.ftbqlocal.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

public class PackUtils {
    public static void createResourcePack(File file, String outputName) throws IOException {
        JsonObject packObject = PackUtils.generatePackMcmeta("Localization Resourcepack", 8);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonOutput = gson.toJson((JsonElement)packObject);
        File packMcMeta = new File("pack.mcmeta");
        FileUtils.write((File)packMcMeta, (CharSequence)jsonOutput, (Charset)StandardCharsets.UTF_8);
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(outputName));){
            for (File listFile : Objects.requireNonNull(file.listFiles())) {
                PackUtils.addToZip("assets\\minecraft\\lang\\", listFile, zipOut);
            }
            PackUtils.addToZip("", packMcMeta, zipOut);
            System.out.println("Zip file created successfully!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addToZip(String path, File file, ZipOutputStream zipOut) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            int length;
            ZipEntry zipEntry = new ZipEntry(path + file.getName());
            zipOut.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOut.write(bytes, 0, length);
            }
            zipOut.closeEntry();
        }
    }

    public static JsonObject generatePackMcmeta(String description, int packFormat) {
        JsonObject packObject = new JsonObject();
        JsonObject packMeta = new JsonObject();
        packMeta.addProperty("pack_format", (Number)packFormat);
        packMeta.addProperty("description", description);
        packObject.add("pack", (JsonElement)packMeta);
        return packObject;
    }
}

