/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.registry.tool;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.IRegistryDataLoader;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.BlockContext;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.IMatcherFactory;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.Matchers;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ModMatcher;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;

public class ToolRegistry {
    private static final String TOOLS_PROPERTY = "tools";
    private static final Set<String> modsWithMapping = new HashSet<String>();
    private static final ToolMapping<Block, BlockContext> BLOCK_TOOL_MAPPING = new ToolMapping<Block, BlockContext>(ForgeRegistries.BLOCKS, BlockContext::getBlock);
    private static final ToolMapping<EntityType<?>, Entity> ENTITY_TOOL_MAPPING = new ToolMapping<EntityType, Entity>(ForgeRegistries.ENTITY_TYPES, Entity::m_6095_);

    private ToolRegistry() {
    }

    public static boolean isToolForBlock(ItemStack stack, Block block, Level world, BlockState blockState, BlockPos pos) {
        return BLOCK_TOOL_MAPPING.isToolFor(stack, block, () -> new BlockContext(world, blockState, block, pos));
    }

    public static boolean isToolForEntity(ItemStack stack, Entity entity) {
        return ENTITY_TOOL_MAPPING.isToolFor(stack, entity.m_6095_(), () -> entity);
    }

    protected static Tuple<Set<Item>, Set<Predicate<ItemStack>>> getItemsAndItemPredicates(Map.Entry<String, JsonElement> property) {
        if (property.getValue().isJsonArray()) {
            JsonArray toolArray = GsonHelper.m_13924_((JsonElement)property.getValue(), (String)"");
            return ToolRegistry.getItemsAndItemPredicates(toolArray);
        }
        SophisticatedBackpacks.LOGGER.error("Invalid tools list - needs to be an array {}", (Object)property.getValue());
        return new Tuple(Collections.emptySet(), Collections.emptySet());
    }

    protected static Tuple<Set<Item>, Set<Predicate<ItemStack>>> getItemsAndItemPredicates(JsonArray toolArray) {
        HashSet<Item> items = new HashSet<Item>();
        HashSet itemPredicates = new HashSet();
        for (JsonElement jsonElement : toolArray) {
            if (jsonElement.isJsonPrimitive()) {
                ResourceLocation itemName = new ResourceLocation(jsonElement.getAsString());
                if (!ForgeRegistries.ITEMS.containsKey(itemName)) {
                    SophisticatedBackpacks.LOGGER.debug("{} isn't loaded in item registry, skipping ...", (Object)itemName);
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemName);
                items.add(item);
                continue;
            }
            if (!jsonElement.isJsonObject()) continue;
            Matchers.getItemMatcher(jsonElement).ifPresent(itemPredicates::add);
        }
        return new Tuple(items, itemPredicates);
    }

    public static void addModWithMapping(String modId) {
        modsWithMapping.add(modId);
    }

    private static class ToolMapping<V, C> {
        private final IForgeRegistry<V> registry;
        private final Function<C, V> getObjectFromContext;
        private final Map<V, Set<Item>> notToolCache = new HashMap<V, Set<Item>>();
        private final Map<V, Set<Item>> objectTools = new HashMap<V, Set<Item>>();
        private final Map<V, Set<Predicate<ItemStack>>> objectToolPredicates = new HashMap<V, Set<Predicate<ItemStack>>>();
        private final Map<Predicate<C>, Set<Item>> objectPredicateTools = new HashMap<Predicate<C>, Set<Item>>();
        private final Map<Predicate<C>, Set<Predicate<ItemStack>>> objectPredicateToolPredicates = new HashMap<Predicate<C>, Set<Predicate<ItemStack>>>();

        public ToolMapping(IForgeRegistry<V> registry, Function<C, V> getObjectFromContext) {
            this.registry = registry;
            this.getObjectFromContext = getObjectFromContext;
        }

        private void addObjectPredicateTools(Tuple<Set<Item>, Set<Predicate<ItemStack>>> tools, Predicate<C> predicate) {
            ((Set)tools.m_14418_()).forEach(t -> this.objectPredicateTools.computeIfAbsent(predicate, p -> new HashSet()).add(t));
            ((Set)tools.m_14419_()).forEach(tp -> this.objectPredicateToolPredicates.computeIfAbsent(predicate, p -> new HashSet()).add(tp));
        }

        private void addObjectTools(Tuple<Set<Item>, Set<Predicate<ItemStack>>> tools, V object) {
            ((Set)tools.m_14418_()).forEach(t -> this.objectTools.computeIfAbsent((Set)object, (Function<Set, Set<Item>>)((Function<Object, Set>)b -> new HashSet())).add(t));
            ((Set)tools.m_14419_()).forEach(tp -> this.objectToolPredicates.computeIfAbsent((Set)object, (Function<Set, Set<Predicate<ItemStack>>>)((Function<Object, Set>)b -> new HashSet())).add(tp));
        }

        public void clear() {
            this.notToolCache.clear();
            this.objectTools.clear();
            this.objectToolPredicates.clear();
            this.objectPredicateTools.clear();
            this.objectPredicateToolPredicates.clear();
        }

        public boolean isToolFor(ItemStack stack, V object, Supplier<C> getContext) {
            Item item = stack.m_41720_();
            if (this.objectTools.containsKey(object) && this.objectTools.get(object).contains(item)) {
                return true;
            }
            if (this.notToolCache.containsKey(object) && this.notToolCache.get(object).contains(item)) {
                return false;
            }
            if (this.tryToMatchAgainstObjectToolPredicates(stack, object)) {
                return true;
            }
            C context = getContext.get();
            if (this.tryToMatchAgainstObjectPredicateTools(item, context)) {
                return true;
            }
            if (this.tryToMatchAgainstObjectPredicateToolPredicates(stack, context)) {
                return true;
            }
            if (this.tryToMatchNoMappingMod(stack, object)) {
                return true;
            }
            this.notToolCache.computeIfAbsent((Set)object, (Function<Set, Set<Item>>)((Function<Object, Set>)b -> new HashSet())).add(item);
            return false;
        }

        private boolean tryToMatchNoMappingMod(ItemStack stack, V object) {
            if (this.isNoMappingModAndNonStackableItemFromSameMod(stack, object)) {
                this.addObjectToolMapping(object, stack.m_41720_());
                return true;
            }
            return false;
        }

        private boolean isNoMappingModAndNonStackableItemFromSameMod(ItemStack stack, V object) {
            return RegistryHelper.getRegistryName(this.registry, object).map(rn -> !rn.m_135827_().equals("minecraft") && !modsWithMapping.contains(rn.m_135827_()) && RegistryHelper.getRegistryName((IForgeRegistry)ForgeRegistries.ITEMS, (Object)stack.m_41720_()).map(itemRegistryName -> itemRegistryName.m_135827_().equals(rn.m_135827_())).orElse(false) != false).orElse(false) != false && stack.m_41741_() == 1;
        }

        private boolean tryToMatchAgainstObjectPredicateToolPredicates(ItemStack stack, C context) {
            for (Map.Entry<Predicate<C>, Set<Predicate<ItemStack>>> entry : this.objectPredicateToolPredicates.entrySet()) {
                if (!entry.getKey().test(context)) continue;
                Set<Predicate<ItemStack>> toolPredicates = entry.getValue();
                if (!this.tryToMatchTools(stack, this.getObjectFromContext.apply(context), toolPredicates)) continue;
                return true;
            }
            return false;
        }

        private boolean tryToMatchAgainstObjectToolPredicates(ItemStack stack, V object) {
            if (this.objectToolPredicates.containsKey(object)) {
                Set<Predicate<ItemStack>> toolPredicates = this.objectToolPredicates.get(object);
                return this.tryToMatchTools(stack, object, toolPredicates);
            }
            return false;
        }

        private boolean tryToMatchAgainstObjectPredicateTools(Item item, C context) {
            for (Map.Entry<Predicate<C>, Set<Item>> entry : this.objectPredicateTools.entrySet()) {
                if (!entry.getKey().test(context) || !entry.getValue().contains(item)) continue;
                this.addObjectToolMapping(this.getObjectFromContext.apply(context), item);
                return true;
            }
            return false;
        }

        private boolean tryToMatchTools(ItemStack stack, V object, Set<Predicate<ItemStack>> toolPredicates) {
            for (Predicate<ItemStack> itemPredicate : toolPredicates) {
                if (!itemPredicate.test(stack)) continue;
                this.objectTools.computeIfAbsent((Set)object, (Function<Set, Set<Item>>)((Function<Object, Set>)b -> new HashSet())).add(stack.m_41720_());
                return true;
            }
            return false;
        }

        private void addObjectToolMapping(V block, Item item) {
            this.objectTools.computeIfAbsent((Set)block, (Function<Set, Set<Item>>)((Function<Object, Set>)b -> new HashSet())).add(item);
        }

        public Map<V, Set<Item>> getObjectTools() {
            return this.objectTools;
        }

        public void addModPredicateTools(String modId, Tuple<Set<Item>, Set<Predicate<ItemStack>>> tools) {
            this.addObjectPredicateTools(tools, new ModMatcher<V, IForgeRegistry<V>, C>(this.registry, modId, this.getObjectFromContext));
        }
    }

    public static class EntityToolsLoader
    extends ToolsLoaderBase<EntityType<?>, Entity> {
        public EntityToolsLoader() {
            super(Matchers.getEntityMatcherFactories(), ENTITY_TOOL_MAPPING, ForgeRegistries.ENTITY_TYPES, rn -> Optional.ofNullable((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rn)), "entity_tools", "entities");
        }
    }

    public static class BlockToolsLoader
    extends ToolsLoaderBase<Block, BlockContext> {
        public BlockToolsLoader() {
            super(Matchers.getBlockMatcherFactories(), BLOCK_TOOL_MAPPING, ForgeRegistries.BLOCKS, rn -> Optional.ofNullable((Block)ForgeRegistries.BLOCKS.getValue(rn)), "block_tools", "blocks");
        }
    }

    private static abstract class ToolsLoaderBase<V, C>
    implements IRegistryDataLoader {
        private final List<IMatcherFactory<C>> objectMatcherFactories;
        private final ToolMapping<V, C> toolMapping;
        private final IForgeRegistry<V> registry;
        private final Function<ResourceLocation, Optional<V>> getObjectFromRegistry;
        private final String name;
        private final String objectJsonArrayName;

        public ToolsLoaderBase(List<IMatcherFactory<C>> objectMatcherFactories, ToolMapping<V, C> toolMapping, IForgeRegistry<V> registry, Function<ResourceLocation, Optional<V>> getObjectFromRegistry, String name, String objectJsonArrayName) {
            this.objectMatcherFactories = objectMatcherFactories;
            this.toolMapping = toolMapping;
            this.registry = registry;
            this.getObjectFromRegistry = getObjectFromRegistry;
            this.name = name;
            this.objectJsonArrayName = objectJsonArrayName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void parse(JsonObject json, @Nullable String modId) {
            JsonArray toolsMap = GsonHelper.m_13933_((JsonObject)json, (String)this.name);
            for (JsonElement jsonElement : toolsMap) {
                if (!jsonElement.isJsonObject()) continue;
                JsonObject entry = jsonElement.getAsJsonObject();
                this.parseEntry(entry);
            }
            this.toolMapping.getObjectTools().keySet().forEach(object -> RegistryHelper.getRegistryName(this.registry, (Object)object).ifPresent(rn -> modsWithMapping.add(rn.m_135827_())));
        }

        @Override
        public void clear() {
            this.toolMapping.clear();
            modsWithMapping.clear();
        }

        private void parseEntry(JsonObject entry) {
            if (entry.size() == 1) {
                this.parseFromProperty(entry);
            } else if (entry.size() == 2 && entry.has(this.objectJsonArrayName) && entry.has(ToolRegistry.TOOLS_PROPERTY)) {
                this.parseFromArrays(GsonHelper.m_13933_((JsonObject)entry, (String)this.objectJsonArrayName), GsonHelper.m_13933_((JsonObject)entry, (String)ToolRegistry.TOOLS_PROPERTY));
            } else {
                SophisticatedBackpacks.LOGGER.error("Invalid block tools entry - needs to have either 1 array property with mod/entity name or \"{}\" and \"tools\" array properties {}", (Object)this.objectJsonArrayName, (Object)entry);
            }
        }

        private void parseFromArrays(JsonArray blocksArray, JsonArray toolsArray) {
            Tuple<Set<Item>, Set<Predicate<ItemStack>>> tools = ToolRegistry.getItemsAndItemPredicates(toolsArray);
            if (((Set)tools.m_14418_()).isEmpty() && ((Set)tools.m_14419_()).isEmpty()) {
                return;
            }
            for (JsonElement jsonElement : blocksArray) {
                if (jsonElement.isJsonPrimitive() && jsonElement.getAsString().contains(":")) {
                    this.parseObjectEntry(tools, jsonElement.getAsString());
                    continue;
                }
                this.parseObjectPredicateEntry(tools, jsonElement);
            }
        }

        private void parseObjectPredicateEntry(Tuple<Set<Item>, Set<Predicate<ItemStack>>> tools, JsonElement jsonElement) {
            for (IMatcherFactory<C> blockMatcherFactory : this.objectMatcherFactories) {
                if (!blockMatcherFactory.appliesTo(jsonElement)) continue;
                blockMatcherFactory.getPredicate(jsonElement).ifPresent(predicate -> this.toolMapping.addObjectPredicateTools(tools, (Predicate<C>)predicate));
                break;
            }
        }

        private void parseObjectEntry(Tuple<Set<Item>, Set<Predicate<ItemStack>>> tools, String objectName) {
            ResourceLocation registryName = new ResourceLocation(objectName);
            Optional<V> objectOptional = this.getObjectFromRegistry.apply(registryName);
            if (objectOptional.isPresent()) {
                this.toolMapping.addObjectTools(tools, objectOptional.get());
            } else {
                SophisticatedBackpacks.LOGGER.debug("{} doesn't exist in registry, skipping ...", (Object)objectName);
            }
        }

        private void parseFromProperty(JsonObject entry) {
            for (Map.Entry property : entry.entrySet()) {
                if (((String)property.getKey()).contains(":")) {
                    this.parseObjectTools(property);
                    continue;
                }
                this.parseModTools(property);
            }
        }

        private void parseModTools(Map.Entry<String, JsonElement> property) {
            String modId = property.getKey();
            if (!ModList.get().isLoaded(modId)) {
                SophisticatedBackpacks.LOGGER.debug("{} mod isn't loaded, skipping ... {} ", (Object)modId, property);
                return;
            }
            Tuple<Set<Item>, Set<Predicate<ItemStack>>> tools = ToolRegistry.getItemsAndItemPredicates(property);
            if (((Set)tools.m_14418_()).isEmpty() && ((Set)tools.m_14419_()).isEmpty()) {
                return;
            }
            this.toolMapping.addModPredicateTools(modId, tools);
        }

        private void parseObjectTools(Map.Entry<String, JsonElement> property) {
            Tuple<Set<Item>, Set<Predicate<ItemStack>>> tools = ToolRegistry.getItemsAndItemPredicates(property);
            if (((Set)tools.m_14418_()).isEmpty() && ((Set)tools.m_14419_()).isEmpty()) {
                return;
            }
            this.parseObjectEntry(tools, property.getKey());
        }
    }
}

