/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry.packets;

import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.Trusted;
import dev.ithundxr.createnumismatics.multiloader.C2SPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class BlockEntityConfigurationPacket<BE extends SyncedBlockEntity>
implements C2SPacket {
    protected BlockPos pos;

    public BlockEntityConfigurationPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.readSettings(buf);
    }

    public BlockEntityConfigurationPacket(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        this.writeSettings(buffer);
    }

    @Override
    public void handle(ServerPlayer sender) {
        Level world = sender.m_9236_();
        if (world == null || !world.m_46749_(this.pos)) {
            return;
        }
        if (!this.pos.m_123314_((Vec3i)sender.m_20183_(), (double)this.maxRange())) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(this.pos);
        if (blockEntity instanceof SyncedBlockEntity) {
            Trusted trusted;
            if (blockEntity instanceof Trusted && !(trusted = (Trusted)blockEntity).isTrusted((Player)sender)) {
                Numismatics.LOGGER.error("Illegal configuration of %s at %s attempted by player %s".formatted(blockEntity, this.pos, sender));
                sender.f_8906_.m_9942_((Component)Component.m_237113_((String)"Haxx: Illegal block entity configuration attempt"));
                return;
            }
            this.applySettings(sender, (SyncedBlockEntity)blockEntity);
            if (!this.causeUpdate()) {
                return;
            }
            ((SyncedBlockEntity)blockEntity).sendData();
            blockEntity.m_6596_();
        }
    }

    protected int maxRange() {
        return 20;
    }

    protected abstract void writeSettings(FriendlyByteBuf var1);

    protected abstract void readSettings(FriendlyByteBuf var1);

    protected void applySettings(ServerPlayer player, BE be) {
        this.applySettings(be);
    }

    protected boolean causeUpdate() {
        return true;
    }

    protected abstract void applySettings(BE var1);
}

