/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.client.blockentity.clock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;

public class ClockRenderHelper {
    private RandomSource random;
    private PoseStack poseStack;
    private RenderType renderType;
    private VertexConsumer vertexConsumer;
    private BlockState blockState;
    private float partialTick;
    private int packedLight;
    private int packedOverlay;
    private BakedModel model;
    private Vec3 pivotPoint = Vec3.f_82478_;
    private Vec3 position = Vec3.f_82478_;
    private float rotZ;

    public void rotateForDirection(Direction direction) {
        float yRot = direction.m_122424_().m_122435_() * ((float)Math.PI / 180);
        this.poseStack.m_85837_(this.pivotPoint.m_7096_(), this.pivotPoint.m_7098_(), this.pivotPoint.m_7094_());
        this.poseStack.m_252781_(Axis.f_252392_.m_252961_(yRot));
        this.poseStack.m_85837_(-this.pivotPoint.m_7096_(), -this.pivotPoint.m_7098_(), -this.pivotPoint.m_7094_());
        this.poseStack.m_85837_(this.position.m_7096_(), this.position.m_7098_(), this.position.m_7094_());
    }

    public void render(BlockRenderDispatcher blockRenderer) {
        if (null == this.model) {
            return;
        }
        this.poseStack.m_85836_();
        this.poseStack.m_85837_(this.position.m_7096_(), this.position.m_7098_(), this.position.m_7094_());
        this.poseStack.m_85837_(this.pivotPoint.m_7096_(), this.pivotPoint.m_7098_(), this.pivotPoint.m_7094_());
        this.poseStack.m_252781_(Axis.f_252403_.m_252961_(this.rotZ));
        this.poseStack.m_85837_(-this.pivotPoint.m_7096_(), -this.pivotPoint.m_7098_(), -this.pivotPoint.m_7094_());
        for (RenderType renderType : this.model.getRenderTypes(this.blockState, this.random, ModelData.EMPTY)) {
            blockRenderer.m_110937_().renderModel(this.poseStack.m_85850_(), this.vertexConsumer, this.blockState, this.model, 1.0f, 1.0f, 1.0f, this.packedLight, this.packedOverlay, ModelData.EMPTY, renderType);
        }
        this.poseStack.m_85849_();
    }

    public ClockRenderHelper withPoseStack(PoseStack poseStack) {
        this.poseStack = poseStack;
        return this;
    }

    public ClockRenderHelper withRandom(RandomSource random) {
        this.random = random;
        return this;
    }

    public ClockRenderHelper withBlockState(BlockState blockState) {
        this.blockState = blockState;
        return this;
    }

    public ClockRenderHelper withModel(BakedModel bakedModel) {
        this.model = bakedModel;
        return this;
    }

    public ClockRenderHelper withRenderType(MultiBufferSource bufferSource, RenderType renderType) {
        this.renderType = renderType;
        this.vertexConsumer = bufferSource.m_6299_(renderType);
        return this;
    }

    public ClockRenderHelper withPackedLight(int packedLight) {
        this.packedLight = packedLight;
        return this;
    }

    public ClockRenderHelper withPackedOverlay(int packedOverlay) {
        this.packedOverlay = packedOverlay;
        return this;
    }

    public ClockRenderHelper withPivotPoint(Vec3 pivotPoint) {
        this.pivotPoint = pivotPoint;
        return this;
    }

    public ClockRenderHelper withPosition(Vec3 position) {
        this.position = position;
        return this;
    }

    public ClockRenderHelper withPartialTick(float partialTick) {
        this.partialTick = partialTick;
        return this;
    }

    public ClockRenderHelper withRotationZ(float zRotation) {
        this.rotZ = zRotation;
        return this;
    }

    public PoseStack getPoseStack() {
        return this.poseStack;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public VertexConsumer getVertexConsumer() {
        return this.vertexConsumer;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public int getPackedLight() {
        return this.packedLight;
    }

    public int getPackedOverlay() {
        return this.packedOverlay;
    }

    public BakedModel getModel() {
        return this.model;
    }

    public Vec3 getPivotPoint() {
        return this.pivotPoint;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public float getPartialTick() {
        return this.partialTick;
    }

    public float getRotationZ() {
        return this.rotZ;
    }
}

