/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.misc;

import com.google.common.collect.Iterables;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tanukidecor.TDRegistry;
import tanukidecor.block.RotatingMultiblock;
import tanukidecor.block.entity.TrainSetBlockEntity;
import tanukidecor.util.MultiblockHandler;

public class TrainSetBlock
extends RotatingMultiblock
implements EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final Vec3i DEFAULT_INDEX = new Vec3i(0, 0, -1);
    private static final MultiblockHandler HOLLOW_MULTIBLOCK_HANDLER = new MultiblockHandler(3, 1, 3){

        @Override
        public Iterable<BlockPos> getPositions(BlockPos center, Direction facing) {
            return Iterables.filter(super.getPositions(center, facing), p -> !center.equals(p));
        }

        @Override
        public void iterateIndices(Consumer<Vec3i> consumer) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int x = this.minIndex.m_123341_(); x <= this.maxIndex.m_123341_(); ++x) {
                for (int y = this.minIndex.m_123342_(); y <= this.maxIndex.m_123342_(); ++y) {
                    for (int z = this.minIndex.m_123343_(); z <= this.maxIndex.m_123343_(); ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        consumer.accept((Vec3i)mutable.m_122178_(x, y, z));
                    }
                }
            }
        }

        @Override
        public BlockState getStateForPlacement(BlockPlaceContext context, BlockState blockState, Direction facing) {
            Level level = context.m_43725_();
            BlockPos center = this.getCenterPos(context.m_8083_(), blockState, facing);
            if (!this.allPositions(center, facing, p -> level.m_46739_(p) && level.m_8055_(p).m_60629_(context))) {
                return null;
            }
            return this.getIndexedState(blockState, DEFAULT_INDEX);
        }

        @Override
        public void preventCreativeDropFromCenterPart(Level level, BlockPos pos, BlockState blockState, Direction facing, Player player) {
            BlockPos origin = this.getCenterPos(pos, blockState, facing).m_121955_(MultiblockHandler.indexToOffset(DEFAULT_INDEX, facing));
            BlockState originState = level.m_8055_(origin);
            if (originState.m_60713_(blockState.m_60734_()) && this.getIndex(originState).equals((Object)DEFAULT_INDEX)) {
                level.m_7731_(origin, originState.m_60819_().m_76188_(), 35);
            }
        }
    };
    public static final VoxelShape[][][] SHAPE = new VoxelShape[][][]{{{Shapes.m_83110_((VoxelShape)TrainSetBlock.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)5.0, (double)2.0, (double)16.0), (VoxelShape)TrainSetBlock.m_49796_((double)5.0, (double)0.0, (double)10.0, (double)10.0, (double)2.0, (double)16.0)), TrainSetBlock.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)10.0, (double)2.0, (double)16.0), Shapes.m_83110_((VoxelShape)TrainSetBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)2.0, (double)10.0), (VoxelShape)TrainSetBlock.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)10.0, (double)2.0, (double)5.0))}, {TrainSetBlock.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)2.0, (double)10.0), Shapes.m_83040_(), TrainSetBlock.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)2.0, (double)10.0)}, {Shapes.m_83110_((VoxelShape)TrainSetBlock.m_49796_((double)10.0, (double)0.0, (double)5.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)TrainSetBlock.m_49796_((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)2.0, (double)16.0)), TrainSetBlock.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)10.0, (double)2.0, (double)16.0), Shapes.m_83110_((VoxelShape)TrainSetBlock.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)5.0), (VoxelShape)TrainSetBlock.m_49796_((double)11.0, (double)0.0, (double)5.0, (double)16.0, (double)2.0, (double)10.0))}}, new VoxelShape[0][], new VoxelShape[0][]};

    public TrainSetBlock(BlockBehaviour.Properties pProperties) {
        super(HOLLOW_MULTIBLOCK_HANDLER, RotatingMultiblock.createMultiblockShapeBuilder(HOLLOW_MULTIBLOCK_HANDLER, SHAPE), pProperties);
        this.m_49959_((BlockState)((BlockState)this.multiblockHandler.getIndexedState((BlockState)this.f_49792_.m_61090_(), DEFAULT_INDEX).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!pLevel.m_5776_() && pFromPos.m_123342_() == pPos.m_123342_() - 1 && (blockEntity = pLevel.m_7702_(pPos)) instanceof TrainSetBlockEntity) {
            TrainSetBlockEntity blockEntity2 = (TrainSetBlockEntity)blockEntity;
            Direction facing = (Direction)pState.m_61143_((Property)FACING);
            MultiblockHandler multiblockHandler = this.getMultiblockHandler();
            boolean silent = multiblockHandler.anyPositions(multiblockHandler.getCenterPos(pPos, pState, facing), facing, b -> pLevel.m_8055_(b.m_7495_()).m_204336_(BlockTags.f_144272_));
            blockEntity2.setSilent(silent);
        }
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (this.getMultiblockHandler().getIndex(pState).equals((Object)DEFAULT_INDEX)) {
            return ((BlockEntityType)TDRegistry.BlockEntityReg.TRAIN_SET.get()).m_155264_(pPos, pState);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.m_5776_() ? TrainSetBlockEntity::tick : null;
    }
}

