/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.clock;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public interface IChimeProvider {
    public static final long DAWN = 10L;
    public static final long NOON = 6000L;
    public static final long MIDNIGHT = 18000L;
    public static final long MIN_CHIME_INTERVAL = 40L;

    @Nullable
    default public SoundEvent getChimeSound(BlockState blockState) {
        return null;
    }

    @Nullable
    default public SoundEvent getTickSound(BlockState blockState) {
        return null;
    }

    default public int getTickSoundInterval(BlockState blockState) {
        return 20;
    }

    default public boolean isTimeToChime(BlockState blockState, long dayTime) {
        return dayTime == 6000L || dayTime == 6040L || dayTime == 18000L;
    }

    default public float getChimeVolume(BlockState blockState, RandomSource random, long dayTime) {
        return 1.0f;
    }

    default public float getChimePitch(BlockState blockState, RandomSource random, long dayTime) {
        return 1.0f;
    }

    default public float getTickVolume(BlockState blockState, RandomSource random, long dayTime) {
        return 0.6f;
    }

    default public float getTickPitch(BlockState blockState, RandomSource random, long dayTime) {
        return 1.0f;
    }
}

