/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.clock;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tanukidecor.TDRegistry;
import tanukidecor.block.RotatingMultiblock;
import tanukidecor.block.clock.IChimeProvider;
import tanukidecor.block.entity.ClockBlockEntity;
import tanukidecor.util.MultiblockHandler;
import tanukidecor.util.ShapeUtils;

public class GrandfatherClockBlock
extends RotatingMultiblock
implements EntityBlock,
IChimeProvider {
    protected final Supplier<SoundEvent> chimeSound;
    protected final Supplier<SoundEvent> tickSound = TDRegistry.SoundReg.GRANDFATHER_CLOCK_TICK;
    public static VoxelShape[] SHAPES = new VoxelShape[]{Shapes.m_83124_((VoxelShape)GrandfatherClockBlock.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)4.0, (double)15.0), (VoxelShape[])new VoxelShape[]{GrandfatherClockBlock.m_49796_((double)1.0, (double)4.0, (double)2.0, (double)15.0, (double)12.0, (double)14.0), GrandfatherClockBlock.m_49796_((double)2.0, (double)12.0, (double)3.0, (double)14.0, (double)16.0, (double)13.0)}), GrandfatherClockBlock.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)16.0, (double)13.0), Shapes.m_83124_((VoxelShape)GrandfatherClockBlock.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0, (double)15.0), (VoxelShape[])new VoxelShape[]{GrandfatherClockBlock.m_49796_((double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)12.0, (double)13.0), GrandfatherClockBlock.m_49796_((double)0.0, (double)12.0, (double)2.0, (double)6.0, (double)16.0, (double)15.0), GrandfatherClockBlock.m_49796_((double)10.0, (double)12.0, (double)2.0, (double)16.0, (double)16.0, (double)15.0), GrandfatherClockBlock.m_49796_((double)6.0, (double)12.0, (double)2.0, (double)10.0, (double)14.0, (double)15.0), GrandfatherClockBlock.m_49796_((double)13.0, (double)2.0, (double)3.0, (double)15.0, (double)12.0, (double)5.0), GrandfatherClockBlock.m_49796_((double)1.0, (double)2.0, (double)3.0, (double)3.0, (double)12.0, (double)5.0), GrandfatherClockBlock.m_49796_((double)13.0, (double)2.0, (double)12.0, (double)15.0, (double)12.0, (double)14.0), GrandfatherClockBlock.m_49796_((double)1.0, (double)2.0, (double)12.0, (double)3.0, (double)12.0, (double)14.0)})};

    public GrandfatherClockBlock(BlockBehaviour.Properties pProperties) {
        super(MultiblockHandler.MULTIBLOCK_1X3X1, GrandfatherClockBlock::buildShape, pProperties);
        this.chimeSound = TDRegistry.SoundReg.GRANDFATHER_CLOCK_CHIME;
    }

    @Override
    @Nullable
    public SoundEvent getChimeSound(BlockState blockState) {
        return this.chimeSound.get();
    }

    @Override
    @Nullable
    public SoundEvent getTickSound(BlockState blockState) {
        return this.tickSound.get();
    }

    @Override
    public int getTickSoundInterval(BlockState blockState) {
        return 40;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (this.getMultiblockHandler().isCenterState(pState)) {
            return ((BlockEntityType)TDRegistry.BlockEntityReg.GRANDFATHER_CLOCK.get()).m_155264_(pPos, pState);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return !pLevel.m_5776_() ? ClockBlockEntity::tick : null;
    }

    public static VoxelShape buildShape(BlockState blockState) {
        Vec3i index = MultiblockHandler.MULTIBLOCK_1X3X1.getIndex(blockState);
        Vec3i dimensions = MultiblockHandler.MULTIBLOCK_1X3X1.getDimensions();
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        VoxelShape shape = SHAPES[index.m_123342_() + dimensions.m_123342_() / 2];
        return ShapeUtils.rotateShape(MultiblockHandler.ORIGIN_DIRECTION, facing, shape);
    }
}

