/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.bed;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface IBedProvider {
    public void removeBed(Level var1, BlockPos var2, BlockState var3);

    public BlockPos getHeadPos(BlockState var1, Level var2, BlockPos var3);

    public boolean isHeadOfBed(BlockState var1);

    default public InteractionResult useBed(BlockState blockState, Level level, BlockPos pos, Player player) {
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        BlockPos headPos = this.getHeadPos(blockState, level, pos);
        BlockState headState = level.m_8055_(headPos);
        if (!headState.m_60713_(blockState.m_60734_())) {
            return InteractionResult.CONSUME;
        }
        if (!BedBlock.m_49488_((Level)level)) {
            this.removeBed(level, headPos, headState);
            Vec3 explosionPos = Vec3.m_82512_((Vec3i)headPos);
            level.m_254877_(null, level.m_269111_().m_269488_(explosionPos), null, explosionPos.m_7096_(), explosionPos.m_7098_(), explosionPos.m_7094_(), 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)headState.m_61143_((Property)BlockStateProperties.f_61445_)).booleanValue()) {
            if (!IBedProvider.kickVillagerOutOfBed(level, headPos)) {
                player.m_5661_((Component)Component.m_237115_((String)"block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        player.m_7720_(headPos).ifLeft(problem -> {
            if (problem != null) {
                player.m_5661_(problem.m_36423_(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    public static boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List list = level.m_6443_(Villager.class, new AABB(pos), LivingEntity::m_5803_);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).m_5796_();
        return true;
    }

    public static void bounceUp(Entity pEntity) {
        Vec3 vec3 = pEntity.m_20184_();
        if (vec3.f_82480_ < 0.0) {
            double d0 = pEntity instanceof LivingEntity ? 1.0 : 0.8;
            pEntity.m_20334_(vec3.f_82479_, -vec3.f_82480_ * (double)0.66f * d0, vec3.f_82481_);
        }
    }
}

