/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tanukidecor.block.storage.IDelegateProvider;
import tanukidecor.util.MultiblockHandler;
import tanukidecor.util.ShapeBuilder;
import tanukidecor.util.ShapeUtils;

public class RotatingMultiblock
extends Block
implements SimpleWaterloggedBlock,
IDelegateProvider {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61374_;
    protected static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected final MultiblockHandler multiblockHandler;
    protected final Map<BlockState, VoxelShape> blockShapes = new HashMap<BlockState, VoxelShape>();
    protected final Map<BlockState, VoxelShape> multiblockShapes = new HashMap<BlockState, VoxelShape>();
    private final ShapeBuilder shapeBuilder;

    protected RotatingMultiblock(MultiblockHandler multiblockHandler, ShapeBuilder shapeBuilder, BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60988_());
        this.multiblockHandler = multiblockHandler;
        this.shapeBuilder = shapeBuilder;
        this.f_49792_ = this.createStateDefinition();
        this.m_49959_(this.multiblockHandler.getCenterState((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(FACING, (Comparable)Direction.NORTH)));
        this.precalculateShapes();
    }

    public MultiblockHandler getMultiblockHandler() {
        return this.multiblockHandler;
    }

    protected StateDefinition<Block, BlockState> createStateDefinition() {
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.createMultiblockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder);
        return builder.m_61101_(Block::m_49966_, BlockState::new);
    }

    @Override
    public BlockPos getDelegatePos(BlockState blockState, BlockPos blockPos) {
        return this.multiblockHandler.getCenterPos(blockPos, blockState, (Direction)blockState.m_61143_(FACING));
    }

    @Deprecated
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{FACING}));
    }

    protected void createMultiblockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        this.multiblockHandler.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{FACING}));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction = pContext.m_8125_().m_122424_();
        boolean waterlogged = pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_;
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        return this.multiblockHandler.getStateForPlacement(pContext, blockState, direction);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (!this.multiblockHandler.canSurvive(pState, (LevelReader)pLevel, pCurrentPos, (Direction)pState.m_61143_(FACING))) {
            return this.m_5888_(pState).m_76188_();
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        this.multiblockHandler.onBlockPlaced(pLevel, pPos, pState, (Direction)pState.m_61143_(FACING));
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (!pLevel.m_8055_(pPos).m_60713_((Block)this)) {
            return true;
        }
        return this.multiblockHandler.canSurvive(pState, pLevel, pPos, (Direction)pState.m_61143_(FACING));
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pLevel.m_5776_() && pPlayer.m_7500_()) {
            this.multiblockHandler.preventCreativeDropFromCenterPart(pLevel, pPos, pState, (Direction)pState.m_61143_(FACING), pPlayer);
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public void removeAll(Level level, BlockPos centerPos) {
        BlockPos.MutableBlockPos mutablePos = centerPos.m_122032_();
        this.getMultiblockHandler().iterateIndices(index -> level.m_7471_((BlockPos)mutablePos.m_175306_((Vec3i)centerPos, index), false));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.f_60443_ ? this.getBlockShape(pState) : Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getMultiblockShape(pState);
    }

    protected void precalculateShapes() {
        this.blockShapes.clear();
        this.multiblockShapes.clear();
        EnumMap<Direction, VoxelShape> centeredVisualShapes = new EnumMap<Direction, VoxelShape>(Direction.class);
        centeredVisualShapes.putAll(ShapeUtils.rotateShapes(MultiblockHandler.ORIGIN_DIRECTION, this.createMultiblockShape()));
        for (BlockState blockState : this.f_49792_.m_61056_()) {
            this.blockShapes.put(blockState, (VoxelShape)this.shapeBuilder.apply(blockState));
            Direction direction = (Direction)blockState.m_61143_(FACING);
            Vec3i index = this.multiblockHandler.getIndex(blockState);
            Vec3i offset = MultiblockHandler.indexToOffset(index, direction);
            VoxelShape shape = ((VoxelShape)centeredVisualShapes.get(blockState.m_61143_(FACING))).m_83216_((double)(-offset.m_123341_()), (double)(-offset.m_123342_()), (double)(-offset.m_123343_()));
            this.multiblockShapes.put(blockState, shape);
        }
    }

    protected VoxelShape createMultiblockShape() {
        BlockState blockState = this.multiblockHandler.getCenterState(this.m_49966_());
        AtomicReference<VoxelShape> shape = new AtomicReference<VoxelShape>(Shapes.m_83040_());
        this.multiblockHandler.iterateIndices(index -> {
            BlockState b = this.multiblockHandler.getIndexedState(blockState, (Vec3i)index);
            shape.set(ShapeUtils.orUnoptimized((VoxelShape)shape.get(), this.blockShapes.computeIfAbsent(b, this.shapeBuilder).m_83216_((double)(-index.m_123341_()), (double)index.m_123342_(), (double)index.m_123343_())));
        });
        return shape.get().m_83296_();
    }

    public VoxelShape getBlockShape(BlockState blockState) {
        return this.blockShapes.get(blockState);
    }

    public VoxelShape getMultiblockShape(BlockState blockState) {
        return this.multiblockShapes.get(blockState);
    }

    public static ShapeBuilder createMultiblockShapeBuilder(MultiblockHandler handler, VoxelShape[][][] template) {
        return blockState -> {
            Vec3i index = handler.getIndex((BlockState)blockState);
            Vec3i dimensions = handler.getDimensions();
            Direction facing = (Direction)blockState.m_61143_(FACING);
            int heightIndex = index.m_123342_() + dimensions.m_123342_() / 2;
            int widthIndex = index.m_123341_() + dimensions.m_123341_() / 2;
            int depthIndex = index.m_123343_() + dimensions.m_123343_() / 2;
            VoxelShape shape = template[heightIndex][widthIndex][depthIndex];
            return ShapeUtils.rotateShape(MultiblockHandler.ORIGIN_DIRECTION, facing, shape);
        };
    }
}

