/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.item.Paraglider;

public abstract class ParagliderItem
extends Item
implements DyeableLeatherItem,
Paraglider {
    private final int defaultColor;

    public ParagliderItem(int defaultColor) {
        super(new Item.Properties().m_41487_(1));
        this.defaultColor = defaultColor;
    }

    public int m_41121_(@NotNull ItemStack stack) {
        CompoundTag nbt = stack.m_41737_("display");
        return nbt != null && nbt.m_128425_("color", 99) ? nbt.m_128451_("color") : this.defaultColor;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (stack.m_41763_() && stack.m_41776_() <= stack.m_41773_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.paraglider.paraglider_broken").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
    }

    @Override
    public boolean canDoParagliding(@NotNull ItemStack stack) {
        return !stack.m_41763_() || stack.m_41776_() > stack.m_41773_();
    }

    @Override
    public boolean isParagliding(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_("Paragliding");
    }

    @Override
    public void setParagliding(@NotNull ItemStack stack, boolean paragliding) {
        if (this.isParagliding(stack) == paragliding) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (paragliding) {
            tag.m_128379_("Paragliding", true);
        } else {
            tag.m_128473_("Paragliding");
        }
    }

    @Override
    public void damageParaglider(@NotNull Player player, @NotNull ItemStack stack) {
        ParagliderUtils.damageItemWithoutBreaking(player, stack);
    }
}

