/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.api.bargain;

import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class BargainResult {
    @NotNull
    public static BargainResult success() {
        return Success.instance;
    }

    @NotNull
    public static BargainResult fail(String ... reasons) {
        return new Fail(Set.of(reasons));
    }

    @NotNull
    public static BargainResult fail(@NotNull @NotNull Set<@NotNull String> reasons) {
        return new Fail(Set.copyOf(reasons));
    }

    public abstract boolean isSuccess();

    @NotNull
    public abstract @NotNull @Unmodifiable Set<@NotNull String> failReasons();

    private static final class Success
    extends BargainResult {
        private static final Success instance = new Success();

        private Success() {
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        @NotNull
        public @NotNull @Unmodifiable Set<@NotNull String> failReasons() {
            return Set.of();
        }

        public String toString() {
            return "Success";
        }
    }

    private static final class Fail
    extends BargainResult {
        @NotNull
        private final @NotNull @Unmodifiable Set<@NotNull String> failReasons;

        private Fail(@NotNull @NotNull @Unmodifiable Set<@NotNull String> failReasons) {
            this.failReasons = failReasons;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        @NotNull
        public @NotNull @Unmodifiable Set<@NotNull String> failReasons() {
            return this.failReasons;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Fail)) {
                return false;
            }
            Fail fail = (Fail)obj;
            return Objects.equals(this.failReasons, fail.failReasons);
        }

        public int hashCode() {
            return Objects.hash(this.failReasons);
        }

        public String toString() {
            return "Fail(" + String.join((CharSequence)", ", this.failReasons) + ")";
        }
    }
}

