/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core;

import com.teamabnormals.blueprint.client.screen.splash.SplashSerializers;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.clayworks.client.splashes.WoodworksSplash;
import com.teamabnormals.clayworks.core.ClayworksConfig;
import com.teamabnormals.clayworks.core.data.client.ClayworksBlockStateProvider;
import com.teamabnormals.clayworks.core.data.client.ClayworksLanguageProvider;
import com.teamabnormals.clayworks.core.data.client.ClayworksSplashProvider;
import com.teamabnormals.clayworks.core.data.client.ClayworksSpriteSourceProvider;
import com.teamabnormals.clayworks.core.data.server.ClayworksDatapackBuiltinEntriesProvider;
import com.teamabnormals.clayworks.core.data.server.ClayworksLootTableProvider;
import com.teamabnormals.clayworks.core.data.server.ClayworksRecipeProvider;
import com.teamabnormals.clayworks.core.data.server.modifiers.ClayworksLootModifierProvider;
import com.teamabnormals.clayworks.core.data.server.tags.ClayworksBlockTagsProvider;
import com.teamabnormals.clayworks.core.data.server.tags.ClayworksItemTagsProvider;
import com.teamabnormals.clayworks.core.data.server.tags.ClayworksPaintingVariantTagsProvider;
import com.teamabnormals.clayworks.core.other.ClayworksCompat;
import com.teamabnormals.clayworks.core.registry.ClayworksBlocks;
import com.teamabnormals.clayworks.core.registry.ClayworksLootConditions;
import com.teamabnormals.clayworks.core.registry.ClayworksMenuTypes;
import com.teamabnormals.clayworks.core.registry.ClayworksPaintingVariants;
import com.teamabnormals.clayworks.core.registry.ClayworksParticleTypes;
import com.teamabnormals.clayworks.core.registry.ClayworksRecipes;
import com.teamabnormals.clayworks.core.registry.ClayworksRegistries;
import com.teamabnormals.clayworks.core.registry.helper.ClayworksBlockSubRegistryHelper;
import com.teamabnormals.gallery.core.data.client.GalleryAssetsRemolderProvider;
import com.teamabnormals.gallery.core.data.client.GalleryItemModelProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="clayworks")
public class Clayworks {
    public static final String MOD_ID = "clayworks";
    public static final RegistryHelper REGISTRY_HELPER = RegistryHelper.create((String)"clayworks", helper -> helper.putSubHelper(ForgeRegistries.BLOCKS, (ISubRegistryHelper)new ClayworksBlockSubRegistryHelper((RegistryHelper)helper)));
    public static final RecipeBookType RECIPE_TYPE_BAKING = RecipeBookType.create((String)"BAKING");

    public Clayworks() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        ClayworksLootConditions.LOOT_CONDITION_TYPES.register(bus);
        ClayworksMenuTypes.MENU_TYPES.register(bus);
        ClayworksRecipes.ClayworksRecipeSerializers.RECIPE_SERIALIZERS.register(bus);
        ClayworksRecipes.ClayworksRecipeTypes.RECIPE_TYPES.register(bus);
        ClayworksParticleTypes.PARTICLE_TYPES.register(bus);
        ClayworksPaintingVariants.PAINTING_VARIANTS.register(bus);
        bus.addListener(ClayworksRegistries::registerRegistries);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClayworksBlocks.setupTabEditors();
            SplashSerializers.register((ResourceLocation)new ResourceLocation(MOD_ID, "woodworks"), WoodworksSplash.CODEC);
        });
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ClayworksConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ClayworksCompat.registerCompat());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ClayworksMenuTypes.registerScreenFactories());
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        ClayworksDatapackBuiltinEntriesProvider datapackEntries = new ClayworksDatapackBuiltinEntriesProvider(output, provider);
        generator.addProvider(server, (DataProvider)datapackEntries);
        provider = datapackEntries.getRegistryProvider();
        ClayworksBlockTagsProvider blockTags = new ClayworksBlockTagsProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new ClayworksItemTagsProvider(output, provider, blockTags.m_274426_(), helper));
        generator.addProvider(server, (DataProvider)new ClayworksLootTableProvider(output));
        generator.addProvider(server, (DataProvider)new ClayworksRecipeProvider(output));
        generator.addProvider(server, (DataProvider)new ClayworksPaintingVariantTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new ClayworksLootModifierProvider(output, provider));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new ClayworksSplashProvider(output));
        generator.addProvider(client, (DataProvider)new ClayworksBlockStateProvider(output, helper));
        generator.addProvider(client, (DataProvider)new ClayworksLanguageProvider(output));
        generator.addProvider(client, (DataProvider)new ClayworksSpriteSourceProvider(output, helper));
        if (ModList.get().isLoaded("gallery")) {
            generator.addProvider(client, (DataProvider)new GalleryItemModelProvider(MOD_ID, output, helper));
            generator.addProvider(client, (DataProvider)new GalleryAssetsRemolderProvider(MOD_ID, output, provider));
        }
    }
}

