/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.mixin;

import dev.latvian.mods.kubejs.event.EventJS;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.liopyu.entityjs.builders.modification.ModifyProjectileBuilder;
import net.liopyu.entityjs.events.EntityModificationEventJS;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.liopyu.entityjs.util.EntitySerializerType;
import net.liopyu.entityjs.util.EventHandlers;
import net.liopyu.entityjs.util.implementation.IProjectilsJs;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Projectile.class}, remap=true)
public class ProjectileMixin
implements IProjectilsJs {
    @Unique
    private Object entityJs$builder;
    @Unique
    private Object entityJs$entityObject = this;
    @Unique
    private static final Map<Class<?>, Map<String, EntityDataAccessor<?>>> entityJs$classAccessorMap = new HashMap();
    @Unique
    private final Map<String, EntityDataAccessor<?>> entityJs$accessorMap = new HashMap();

    @Unique
    private Projectile entityJs$getLivingEntity() {
        return (Projectile)this.entityJs$entityObject;
    }

    @Unique
    private String entityJs$entityName() {
        return this.entityJs$getLivingEntity().m_6095_().toString();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=true)
    private void entityjs$onEntityInit(EntityType<?> pEntityType, Level pLevel, CallbackInfo ci) {
        EntityType entityType = this.entityJs$getLivingEntity().m_6095_();
        if (EventHandlers.modifyEntity.hasListeners()) {
            EntityModificationEventJS eventJS = EntityModificationEventJS.getOrCreate(entityType, (Entity)this.entityJs$getLivingEntity());
            EventHandlers.modifyEntity.post((EventJS)eventJS);
            this.entityJs$builder = eventJS.getBuilder();
        }
        this.entityJs$defineSynchedData();
    }

    @Override
    public void entityJs$addSyncedData(EntitySerializerType type, String key, Object value) {
        try {
            EntityDataAccessor accessor;
            String castHint = switch (type.toString().toLowerCase()) {
                case "byte", "int", "float", "long" -> type.toString().toLowerCase();
                default -> null;
            };
            Class<?> entityClass = this.entityJs$getLivingEntity().getClass();
            Map classMap = entityJs$classAccessorMap.computeIfAbsent(entityClass, k -> new HashMap());
            if (classMap.containsKey(key)) {
                accessor = (EntityDataAccessor)classMap.get(key);
            } else {
                EntityDataSerializer<?> serializer = type.getSerializer();
                accessor = SynchedEntityData.m_135353_(entityClass, serializer);
                classMap.put(key, accessor);
            }
            Object finalValue = EntitySerializerType.castValue(value, castHint);
            if (!this.entityJs$getLivingEntity().m_20088_().m_285897_(accessor)) {
                this.entityJs$getLivingEntity().m_20088_().m_135372_(accessor, finalValue);
            } else {
                this.entityJs$getLivingEntity().m_20088_().m_135381_(accessor, finalValue);
            }
            this.entityJs$accessorMap.put(key, accessor);
        }
        catch (Exception e) {
            EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error adding synched data", e);
        }
    }

    @Override
    @Unique
    public void entityJs$addSyncedData(String identifier, Object value) {
        try {
            EntitySerializerType type;
            if (value instanceof Number) {
                Number num = (Number)value;
                double d = num.doubleValue();
                type = num instanceof Float ? EntitySerializerType.FLOAT : (num instanceof Long || d % 1.0 == 0.0 && d > 2.147483647E9 && d <= 9.223372036854776E18 ? EntitySerializerType.LONG : (num instanceof Integer || d % 1.0 == 0.0 && d >= -2.147483648E9 && d <= 2.147483647E9 ? EntitySerializerType.INT : EntitySerializerType.FLOAT));
            } else {
                type = EntitySerializerType.fromObject(value);
            }
            this.entityJs$addSyncedData(type, identifier, value);
        }
        catch (Exception e) {
            EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error adding synched data", e);
        }
    }

    @Override
    @Unique
    public void entityJs$setSyncedData(String key, Object value) {
        EntityDataAccessor<?> accessor = this.entityJs$accessorMap.get(key);
        if (accessor == null) {
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Tried to set undefined synced data key: " + key);
            return;
        }
        EntityDataSerializer serializer = accessor.m_135016_();
        EntitySerializerType type = EntitySerializerType.fromSerializer(serializer);
        String castHint = switch (type.toString().toLowerCase()) {
            case "byte", "int", "float", "long" -> type.toString().toLowerCase();
            default -> null;
        };
        Object casted = EntitySerializerType.castValue(value, castHint);
        this.entityJs$getLivingEntity().m_20088_().m_135381_(accessor, casted);
    }

    @Override
    @Nullable
    public <T> T entityJs$getSyncedData(String identifier) {
        EntityDataAccessor<?> accessor = this.entityJs$accessorMap.get(identifier);
        if (accessor == null) {
            return null;
        }
        if (!this.entityJs$getLivingEntity().m_20088_().m_285897_(accessor)) {
            return null;
        }
        return (T)this.entityJs$getLivingEntity().m_20088_().m_135370_(accessor);
    }

    public void entityJs$defineSynchedData() {
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyProjectileBuilder) {
            ModifyProjectileBuilder builder = (ModifyProjectileBuilder)((Object)object);
            if (builder.defineSyncedData != null) {
                builder.defineSyncedData.accept((Entity)this.entityJs$getLivingEntity());
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void entityjs$writeSyncedData(CompoundTag tag, CallbackInfo ci) {
        CompoundTag jsData = new CompoundTag();
        for (Map.Entry<String, EntityDataAccessor<?>> entry : this.entityJs$accessorMap.entrySet()) {
            String key = entry.getKey();
            EntityDataAccessor<?> accessor = entry.getValue();
            Object value = this.entityJs$getLivingEntity().m_20088_().m_135370_(accessor);
            EntityDataSerializer serializer = accessor.m_135016_();
            EntitySerializerType type = EntitySerializerType.fromSerializer(serializer);
            switch (type) {
                case UUID: {
                    jsData.m_128362_(key, (UUID)value);
                    break;
                }
                case BYTE: {
                    jsData.m_128344_(key, ((Byte)value).byteValue());
                    break;
                }
                case INT: {
                    jsData.m_128405_(key, ((Integer)value).intValue());
                    break;
                }
                case LONG: {
                    jsData.m_128356_(key, ((Long)value).longValue());
                    break;
                }
                case FLOAT: {
                    jsData.m_128350_(key, ((Float)value).floatValue());
                    break;
                }
                case STRING: {
                    jsData.m_128359_(key, (String)value);
                    break;
                }
                case BOOLEAN: {
                    jsData.m_128379_(key, ((Boolean)value).booleanValue());
                    break;
                }
                case COMPOUND_TAG: {
                    jsData.m_128365_(key, (Tag)((CompoundTag)value).m_6426_());
                    break;
                }
                case VECTOR3: {
                    CompoundTag vecTag = new CompoundTag();
                    Vector3f v = (Vector3f)value;
                    vecTag.m_128350_("x", v.x());
                    vecTag.m_128350_("y", v.y());
                    vecTag.m_128350_("z", v.z());
                    jsData.m_128365_(key, (Tag)vecTag);
                    break;
                }
                case QUATERNION: {
                    CompoundTag quatTag = new CompoundTag();
                    Quaternionf q = (Quaternionf)value;
                    quatTag.m_128350_("x", q.x());
                    quatTag.m_128350_("y", q.y());
                    quatTag.m_128350_("z", q.z());
                    quatTag.m_128350_("w", q.w());
                    jsData.m_128365_(key, (Tag)quatTag);
                }
            }
        }
        tag.m_128365_("EntityJSData", (Tag)jsData);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void entityjs$readSyncedData(CompoundTag tag, CallbackInfo ci) {
        if (!tag.m_128425_("EntityJSData", 10)) {
            return;
        }
        CompoundTag jsData = tag.m_128469_("EntityJSData");
        for (String key : jsData.m_128431_()) {
            if (!this.entityJs$accessorMap.containsKey(key)) continue;
            EntityDataAccessor<?> accessor = this.entityJs$accessorMap.get(key);
            EntityDataSerializer serializer = accessor.m_135016_();
            EntitySerializerType type = EntitySerializerType.fromSerializer(serializer);
            Object value = switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case EntitySerializerType.UUID -> jsData.m_128342_(key);
                case EntitySerializerType.BYTE -> jsData.m_128445_(key);
                case EntitySerializerType.INT -> jsData.m_128451_(key);
                case EntitySerializerType.LONG -> jsData.m_128454_(key);
                case EntitySerializerType.FLOAT -> Float.valueOf(jsData.m_128457_(key));
                case EntitySerializerType.STRING -> jsData.m_128461_(key);
                case EntitySerializerType.BOOLEAN -> jsData.m_128471_(key);
                case EntitySerializerType.COMPOUND_TAG -> jsData.m_128469_(key);
                case EntitySerializerType.VECTOR3 -> {
                    CompoundTag vecTag = jsData.m_128469_(key);
                    float x = vecTag.m_128457_("x");
                    float y = vecTag.m_128457_("y");
                    float z = vecTag.m_128457_("z");
                    yield new Vector3f(x, y, z);
                }
                case EntitySerializerType.QUATERNION -> {
                    CompoundTag quatTag = jsData.m_128469_(key);
                    float x = quatTag.m_128457_("x");
                    float y = quatTag.m_128457_("y");
                    float z = quatTag.m_128457_("z");
                    float w = quatTag.m_128457_("w");
                    yield new Quaternionf(x, y, z, w);
                }
            };
            this.entityJs$setSyncedData(key, value);
        }
    }

    @Inject(method={"onHitEntity"}, at={@At(value="HEAD")}, remap=true, cancellable=true)
    protected void onHitEntity(EntityHitResult pResult, CallbackInfo ci) {
        ModifyProjectileBuilder builder;
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyProjectileBuilder && (builder = (ModifyProjectileBuilder)((Object)object)) != null && builder.onHitEntity != null) {
            ContextUtils.ProjectileEntityHitContext context = new ContextUtils.ProjectileEntityHitContext(pResult, this.entityJs$getLivingEntity());
            EntityJSHelperClass.consumerCallback(builder.onHitEntity, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onHitEntity.");
        }
    }

    @Inject(method={"onHitBlock"}, at={@At(value="HEAD")}, remap=true, cancellable=true)
    protected void onHitBlock(BlockHitResult pResult, CallbackInfo ci) {
        ModifyProjectileBuilder builder;
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyProjectileBuilder && (builder = (ModifyProjectileBuilder)((Object)object)) != null && builder.onHitBlock != null) {
            ContextUtils.ProjectileBlockHitContext context = new ContextUtils.ProjectileBlockHitContext(pResult, this.entityJs$getLivingEntity());
            EntityJSHelperClass.consumerCallback(builder.onHitBlock, context, "[EntityJS]: Error in " + this.entityJs$entityName() + "builder for field: onHitBlock.");
        }
    }

    @Inject(method={"canHitEntity"}, at={@At(value="HEAD")}, remap=true, cancellable=true)
    protected void canHitEntity(Entity pTarget, CallbackInfoReturnable<Boolean> cir) {
        ModifyProjectileBuilder builder;
        Object object;
        if (this.entityJs$builder != null && (object = this.entityJs$builder) instanceof ModifyProjectileBuilder && (builder = (ModifyProjectileBuilder)((Object)object)) != null && builder.canHitEntity != null) {
            Object obj = builder.canHitEntity.apply(pTarget);
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                boolean bool = (Boolean)cir.getReturnValue() != false && b != false;
                cir.setReturnValue((Object)bool);
                return;
            }
            EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid canHitEntity for arrow builder: " + obj + ". Must be a boolean. Defaulting to super method: " + cir.getReturnValue());
        }
    }
}

