/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.skillsexpnotifier.client;

import com.github.spacemex.skillsexpnotifier.Config;
import com.github.spacemex.skillsexpnotifier.Skillsexpnotifier;
import com.github.spacemex.skillsexpnotifier.client.SearchForSkills;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class EntryRegistry {
    private static final List<Entry> ENTRIES = new ArrayList<Entry>();

    public static void loadFromFile(Path configDir) {
        Path file = configDir.resolve("SkillExpNotifier/IconMappings.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            if (((Boolean)Config.AUTOREGISTER_DATA.get()).booleanValue()) {
                List<SearchForSkills.CategoryData> auto = SearchForSkills.scan();
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                JsonArray arr = new JsonArray();
                for (SearchForSkills.CategoryData cd : auto) {
                    JsonObject o = new JsonObject();
                    o.addProperty("regex", "^" + Pattern.quote(cd.idPath()) + "$");
                    o.addProperty("icon", cd.iconId());
                    arr.add((JsonElement)o);
                }
                Files.writeString(file, (CharSequence)gson.toJson((JsonElement)arr), new OpenOption[0]);
            }
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                JsonArray defaults = new JsonArray();
                defaults.add((JsonElement)EntryRegistry.makeEntry(".*mining.*", "minecraft:iron_pickaxe", gson));
                defaults.add((JsonElement)EntryRegistry.makeEntry(".*farming.*", "minecraft:iron_hoe", gson));
                defaults.add((JsonElement)EntryRegistry.makeEntry(".*husbandry.*", "minecraft:wheat", gson));
                defaults.add((JsonElement)EntryRegistry.makeEntry(".*fishing.*", "minecraft:fishing_rod", gson));
                defaults.add((JsonElement)EntryRegistry.makeEntry(".*adventuring.*", "minecraft:iron_sword", gson));
                Files.writeString(file, (CharSequence)gson.toJson((JsonElement)defaults), new OpenOption[0]);
            }
            try (BufferedReader reader = Files.newBufferedReader(file);){
                JsonElement root = JsonParser.parseReader((Reader)reader);
                if (!root.isJsonArray()) {
                    Skillsexpnotifier.LOGGER.warn("IconMappings.json isn\u2019t an array, skipping.");
                    return;
                }
                ENTRIES.clear();
                for (JsonElement el : root.getAsJsonArray()) {
                    JsonObject obj = el.getAsJsonObject();
                    String regex = obj.get("regex").getAsString();
                    String iconId = obj.get("icon").getAsString();
                    Pattern p = Pattern.compile(regex, 2);
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)iconId));
                    ItemStack stack = item == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)item);
                    ENTRIES.add(new Entry(p, stack));
                }
            }
        }
        catch (IOException e) {
            Skillsexpnotifier.LOGGER.error("Failed loading IconMappings.json", (Throwable)e);
        }
    }

    private static JsonObject makeEntry(String regex, String icon, Gson g) {
        JsonObject o = new JsonObject();
        o.addProperty("regex", regex);
        o.addProperty("icon", icon);
        return o;
    }

    public static ItemStack getIconFor(String categoryPath) {
        for (Entry e : ENTRIES) {
            if (!e.pattern.matcher(categoryPath).matches()) continue;
            return e.icon.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    private record Entry(Pattern pattern, ItemStack icon) {
    }
}

