/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.StorageModClient;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.platform.Platform;
import com.tom.storagemod.polymorph.PolymorphHelper;
import com.tom.storagemod.polymorph.PolymorphTerminalWidget;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="toms_storage")
public class StorageMod {
    public static final String modid = "toms_storage";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean polymorph;

    public StorageMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> StorageModClient::preInit);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)Config.get());
        MinecraftForge.EVENT_BUS.register((Object)this);
        polymorph = ModList.get().isLoaded("polymorph");
        Content.init();
        Platform.register();
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Tom's Storage Setup starting");
        NetworkHandler.init();
        if (polymorph) {
            PolymorphHelper.init();
        }
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        StorageModClient.clientSetup();
        if (polymorph) {
            PolymorphTerminalWidget.register();
        }
    }
}

