/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.mixin;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Definitions;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Cancellable;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.createmod.catnip.nbt.NBTHelper;
import net.liukrast.eg.api.EGRegistries;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnection;
import net.liukrast.eg.api.util.ConnectionExtra;
import net.liukrast.eg.api.util.IFPExtra;
import net.liukrast.eg.registry.EGPanelConnections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FactoryPanelBehaviour.class}, remap=false)
public abstract class FactoryPanelBehaviourMixin
implements IFPExtra {
    @Unique
    private int extra_gauges$width = 3;
    @Unique
    private final Map<BlockPos, FactoryPanelConnection> extra_gauges$targetedByExtra = new HashMap<BlockPos, FactoryPanelConnection>();
    @Shadow
    public Map<FactoryPanelPosition, FactoryPanelConnection> targetedBy;
    @Shadow
    public boolean active;

    @Shadow
    @Nullable
    public static FactoryPanelBehaviour at(BlockAndTintGetter world, FactoryPanelConnection connection) {
        throw new AssertionError((Object)"Mixin injection failed");
    }

    @Shadow
    public abstract boolean isActive();

    @Override
    public int extra_gauges$getWidth() {
        return this.extra_gauges$width;
    }

    @Override
    public void extra_gauges$setWidth(int width) {
        this.extra_gauges$width = width;
    }

    @Override
    public Map<BlockPos, FactoryPanelConnection> extra_gauges$getExtra() {
        return this.extra_gauges$targetedByExtra;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/foundation/blockEntity/behaviour/filtering/FilteringBehaviour;tick()V", shift=At.Shift.AFTER)}, cancellable=true)
    private void tick(CallbackInfo ci) {
        AbstractPanelBehaviour ab;
        Object t = FactoryPanelBehaviour.class.cast(this);
        if (t instanceof AbstractPanelBehaviour && (ab = (AbstractPanelBehaviour)((Object)t)).skipOriginalTick()) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"at(Lnet/minecraft/world/level/BlockAndTintGetter;Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelPosition;)Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="behaviour", local={@Local(type=FactoryPanelBehaviour.class)}), @Definition(id="active", field={"Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;active:Z"})})
    @Expression(value={"behaviour.active"})
    private static boolean at(FactoryPanelBehaviour instance, Operation<Boolean> original) {
        if (instance == null) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @ModifyVariable(method={"moveTo"}, at=@At(value="STORE", ordinal=0))
    private FactoryPanelBehaviour moveTo(FactoryPanelBehaviour original) {
        FactoryPanelBlockEntity be = (FactoryPanelBlockEntity)original.blockEntity;
        FactoryPanelBlock.PanelSlot slot = original.slot;
        Object v = be.panels.get(slot);
        if (v instanceof AbstractPanelBehaviour) {
            AbstractPanelBehaviour superOriginal = (AbstractPanelBehaviour)((Object)v);
            return superOriginal.getPanelType().create(be, slot);
        }
        return original;
    }

    @Inject(method={"moveTo"}, at={@At(value="INVOKE", target="Ljava/util/Map;keySet()Ljava/util/Set;", ordinal=0)}, cancellable=true)
    private void moveTo(FactoryPanelPosition newPos, ServerPlayer player, CallbackInfo ci) {
        for (BlockPos pos : this.extra_gauges$targetedByExtra.keySet()) {
            if (pos.m_123314_((Vec3i)newPos.pos(), 24.0)) continue;
            ci.cancel();
            return;
        }
    }

    @Redirect(method={"tickRequests"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;targetedBy:Ljava/util/Map;"))
    private Map<FactoryPanelPosition, FactoryPanelConnection> tickRequests(FactoryPanelBehaviour instance) {
        HashMap<FactoryPanelPosition, FactoryPanelConnection> filtered = new HashMap<FactoryPanelPosition, FactoryPanelConnection>();
        block0: for (Map.Entry entry : instance.targetedBy.entrySet()) {
            FactoryPanelBehaviour source = FactoryPanelBehaviour.at((BlockAndTintGetter)instance.getWorld(), (FactoryPanelConnection)((FactoryPanelConnection)entry.getValue()));
            if (source instanceof AbstractPanelBehaviour) {
                AbstractPanelBehaviour ab = (AbstractPanelBehaviour)source;
                for (PanelConnection<?> c : ab.getConnections()) {
                    if (c == EGPanelConnections.FILTER.get()) break;
                    if (c != EGPanelConnections.REDSTONE.get() && c != EGPanelConnections.INTEGER.get() && c != EGPanelConnections.STRING.get()) continue;
                    continue block0;
                }
            }
            filtered.put((FactoryPanelPosition)entry.getKey(), (FactoryPanelConnection)entry.getValue());
        }
        return filtered;
    }

    @Inject(method={"write"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;putUUID(Ljava/lang/String;Ljava/util/UUID;)V", remap=true)})
    private void write(CompoundTag nbt, boolean clientPacket, CallbackInfo ci, @Local(ordinal=1) CompoundTag panelTag) {
        panelTag.m_128365_("TargetedByExtra", (Tag)NBTHelper.writeCompoundList(this.extra_gauges$targetedByExtra.values(), FactoryPanelConnection::write));
        if (this.extra_gauges$width != 3) {
            panelTag.m_128405_("extra_gauges$CraftWidth", this.extra_gauges$width);
        }
    }

    @Inject(method={"read"}, at={@At(value="INVOKE", target="Ljava/util/Map;clear()V")})
    private void read(CompoundTag nbt, boolean clientPacket, CallbackInfo ci, @Local(ordinal=1) CompoundTag panelTag) {
        this.extra_gauges$targetedByExtra.clear();
        NBTHelper.iterateCompoundList((ListTag)panelTag.m_128437_("TargetedByExtra", 10), c -> this.extra_gauges$targetedByExtra.put(FactoryPanelPosition.read((CompoundTag)c).pos(), FactoryPanelConnection.read((CompoundTag)c)));
        this.extra_gauges$width = panelTag.m_128441_("extra_gauges$CraftWidth") ? panelTag.m_128451_("extra_gauges$CraftWidth") : 3;
    }

    @Inject(method={"addConnection"}, at={@At(value="HEAD")}, cancellable=true)
    private void addConnection(FactoryPanelPosition fromPos, CallbackInfo ci) {
        FactoryPanelBehaviour i = (FactoryPanelBehaviour)FactoryPanelBehaviour.class.cast(this);
        BlockState fromState = i.getWorld().m_8055_(fromPos.pos());
        if (PanelConnection.makeContext(i.getWorld().m_8055_(i.getPos())) == PanelConnection.makeContext(fromState) && EGRegistries.PANEL_CONNECTION_REGISTRY.get().getValues().stream().map(c -> c.getListener(fromState.m_60734_())).anyMatch(Objects::nonNull)) {
            this.extra_gauges$targetedByExtra.put(fromPos.pos(), new FactoryPanelConnection(fromPos, 1));
            i.blockEntity.notifyUpdate();
            ci.cancel();
        }
    }

    @Inject(method={"disconnectAllLinks"}, at={@At(value="TAIL")})
    private void disconnectAllLinks(CallbackInfo ci) {
        this.extra_gauges$targetedByExtra.clear();
    }

    @ModifyVariable(method={"checkForRedstoneInput"}, at=@At(value="STORE", ordinal=0))
    private boolean checkForRedstoneInput(boolean shouldPower, @Cancellable CallbackInfo ci) {
        FactoryPanelBehaviour i = (FactoryPanelBehaviour)FactoryPanelBehaviour.class.cast(this);
        for (FactoryPanelConnection connection : this.targetedBy.values()) {
            AbstractPanelBehaviour panel;
            if (!i.getWorld().m_46749_(connection.from.pos())) {
                ci.cancel();
                return false;
            }
            Level world = i.getWorld();
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviourMixin.at((BlockAndTintGetter)world, connection);
            if (behaviour == null || !behaviour.isActive()) {
                return false;
            }
            if (!(behaviour instanceof AbstractPanelBehaviour) || (panel = (AbstractPanelBehaviour)behaviour).hasConnection((PanelConnection)EGPanelConnections.FILTER.get()) || panel.hasConnection((PanelConnection)EGPanelConnections.INTEGER.get())) continue;
            shouldPower |= panel.getConnectionValue(EGPanelConnections.REDSTONE).orElse(0) > 0;
        }
        for (FactoryPanelConnection connection : this.extra_gauges$targetedByExtra.values()) {
            Optional opt;
            BlockPos pos = connection.from.pos();
            if (!i.getWorld().m_46749_(pos)) {
                ci.cancel();
                return false;
            }
            BlockState state = i.getWorld().m_8055_(pos);
            BlockEntity be = i.getWorld().m_7702_(pos);
            ConnectionExtra listener = ((PanelConnection)EGPanelConnections.REDSTONE.get()).getListener(state.m_60734_());
            if (listener == null || !(opt = listener.invalidate(i.getWorld(), state, pos, be)).isPresent()) continue;
            shouldPower |= (Integer)opt.get() > 0;
        }
        return shouldPower;
    }

    @ModifyExpressionValue(method={"checkForRedstoneInput"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="shouldPower", local={@Local(type=boolean.class)}), @Definition(id="redstonePowered", field={"Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBehaviour;redstonePowered:Z"})})
    @Expression(value={"shouldPower == this.redstonePowered"})
    private boolean checkForRedstoneInput$1(boolean original) {
        String fAddress;
        FactoryPanelBehaviour i = (FactoryPanelBehaviour)FactoryPanelBehaviour.class.cast(this);
        Integer total = null;
        StringBuilder addressChange = null;
        block0: for (FactoryPanelConnection connection : this.targetedBy.values()) {
            if (!i.getWorld().m_46749_(connection.from.pos())) {
                return false;
            }
            Level world = i.getWorld();
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviourMixin.at((BlockAndTintGetter)world, connection);
            if (behaviour == null || !behaviour.isActive()) {
                return false;
            }
            if (!(behaviour instanceof AbstractPanelBehaviour)) continue;
            AbstractPanelBehaviour panel = (AbstractPanelBehaviour)behaviour;
            Set<PanelConnection<?>> connections = panel.getConnections();
            for (PanelConnection<?> c : connections) {
                if (c == EGPanelConnections.FILTER.get()) break;
                if (c == EGPanelConnections.INTEGER.get()) {
                    if (total == null) {
                        total = 0;
                    }
                    total = total + panel.getConnectionValue((PanelConnection)EGPanelConnections.INTEGER.get()).orElse(0);
                    continue block0;
                }
                if (c == EGPanelConnections.REDSTONE.get()) continue block0;
                if (c != EGPanelConnections.STRING.get()) continue;
                if (addressChange == null) {
                    addressChange = new StringBuilder(panel.getConnectionValue((PanelConnection)EGPanelConnections.STRING.get()).orElse(""));
                    continue block0;
                }
                addressChange.append(panel.getConnectionValue((PanelConnection)EGPanelConnections.STRING.get()).orElse(""));
                continue block0;
            }
        }
        for (FactoryPanelConnection connection : this.extra_gauges$targetedByExtra.values()) {
            Optional opt;
            Optional opt2;
            BlockPos pos = connection.from.pos();
            if (!i.getWorld().m_46749_(pos)) {
                return false;
            }
            BlockState state = i.getWorld().m_8055_(pos);
            BlockEntity be = i.getWorld().m_7702_(pos);
            ConnectionExtra redstoneListener = ((PanelConnection)EGPanelConnections.REDSTONE.get()).getListener(state.m_60734_());
            if (redstoneListener != null && redstoneListener.invalidate(i.getWorld(), state, pos, be).isPresent()) continue;
            ConnectionExtra intListener = ((PanelConnection)EGPanelConnections.INTEGER.get()).getListener(state.m_60734_());
            if (intListener != null && (opt2 = intListener.invalidate(i.getWorld(), state, pos, be)).isPresent()) {
                total = total + (Integer)opt2.get();
                continue;
            }
            ConnectionExtra listener = ((PanelConnection)EGPanelConnections.STRING.get()).getListener(state.m_60734_());
            if (listener == null || !(opt = listener.invalidate(i.getWorld(), state, pos, be)).isPresent()) continue;
            if (addressChange == null) {
                addressChange = new StringBuilder((String)opt.get());
                continue;
            }
            addressChange.append((String)opt.get());
        }
        String string = fAddress = addressChange == null ? null : addressChange.toString();
        if (!(total != null && total != i.count || fAddress != null && !fAddress.equals(i.recipeAddress))) {
            return false;
        }
        if (total != null) {
            i.count = total;
        }
        if (fAddress != null) {
            i.recipeAddress = fAddress;
        }
        return true;
    }

    @Inject(method={"notifyRedstoneOutputs"}, at={@At(value="TAIL")})
    private void notifyRedstoneOutputs(CallbackInfo ci) {
    }

    @ModifyExpressionValue(method={"onShortInteract"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal=0, remap=true)})
    private boolean onShortInteract(boolean original) {
        AbstractPanelBehaviour panel;
        FactoryPanelBehaviour instance = (FactoryPanelBehaviour)FactoryPanelBehaviour.class.cast(this);
        return instance instanceof AbstractPanelBehaviour ? (panel = (AbstractPanelBehaviour)instance).withFilteringBehaviour() && original : original;
    }

    @ModifyExpressionValue(method={"onShortInteract"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definitions(value={@Definition(id="heldItem", local={@Local(type=ItemStack.class)}), @Definition(id="getItem", method={"Lnet/minecraft/world/item/ItemStack;getItem()Lnet/minecraft/world/item/Item;"}, remap=true), @Definition(id="LogisticallyLinkedBlockItem", type={LogisticallyLinkedBlockItem.class})})
    @Expression(value={"heldItem.getItem() instanceof LogisticallyLinkedBlockItem"})
    private boolean onShortInteract$1(boolean original) {
        FactoryPanelBehaviour instance = (FactoryPanelBehaviour)FactoryPanelBehaviour.class.cast(this);
        return original && !(instance instanceof AbstractPanelBehaviour);
    }

    @ModifyExpressionValue(method={"onShortInteract"}, at={@At(value="INVOKE", target="Ljava/util/Map;size()I")})
    private int onShortInteract(int original) {
        return original + this.extra_gauges$targetedByExtra.size();
    }

    @ModifyExpressionValue(method={"onShortInteract"}, at={@At(value="INVOKE", target="Ljava/util/Map;values()Ljava/util/Collection;")})
    private Collection<FactoryPanelConnection> onShortInteract(Collection<FactoryPanelConnection> original) {
        return Stream.concat(original.stream(), this.extra_gauges$targetedByExtra.values().stream()).collect(Collectors.toSet());
    }
}

