/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics.board;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.registry.PanelType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public abstract class ScrollPanelBehaviour
extends AbstractPanelBehaviour {
    public int value;
    public Component label;
    protected int min;
    protected int max = 1;
    Consumer<Integer> callback;
    Consumer<Integer> clientCallback;
    Function<Integer, String> formatter;
    private Supplier<Boolean> isActive;

    public ScrollPanelBehaviour(Component label, PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super(type, be, slot);
        this.setLabel(label);
        this.callback = i -> {};
        this.clientCallback = i -> {};
        this.formatter = i -> Integer.toString(i);
        this.value = 0;
        this.isActive = () -> true;
    }

    public void between(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public void withFormatter(Function<Integer, String> formatter) {
        this.formatter = formatter;
    }

    @Override
    public void easyWrite(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128405_("ScrollValue", this.value);
        super.easyWrite(nbt, clientPacket);
    }

    @Override
    public void easyRead(CompoundTag nbt, boolean clientPacket) {
        this.value = nbt.m_128441_("ScrollValue") ? nbt.m_128451_("ScrollValue") : 0;
        super.easyRead(nbt, clientPacket);
    }

    public void setValue(int value) {
        if ((value = Mth.m_14045_((int)value, (int)this.min, (int)this.max)) == this.value) {
            return;
        }
        this.value = value;
        this.callback.accept(value);
        this.blockEntity.m_6596_();
        this.blockEntity.sendData();
    }

    public int getValue() {
        return this.value;
    }

    public String formatValue() {
        return this.formatter.apply(this.value);
    }

    public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings settings, boolean ctrlDown) {
        if (settings.equals((Object)this.getValueSettings())) {
            return;
        }
        this.setValue(settings.value());
        this.playFeedbackSound((BlockEntityBehaviour)this);
        this.checkForRedstoneInput();
    }

    public void setLabel(Component label) {
        this.label = label;
    }

    public ValueSettingsBehaviour.ValueSettings getValueSettings() {
        return new ValueSettingsBehaviour.ValueSettings(0, this.value);
    }
}

