/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_attributes.compat.irons_spellbooks;

import de.cadentem.additional_attributes.compat.irons_spellbooks.ISAttributes;
import de.cadentem.additional_attributes.compat.irons_spellbooks.SpellUtils;
import de.cadentem.additional_attributes.config.ServerConfig;
import io.redspace.ironsspellbooks.api.events.ModifySpellLevelEvent;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

public class ISEvents {
    public static void modifyLevel(ModifySpellLevelEvent event) {
        event.setLevel(SpellUtils.calculateSpellLevel(event.getEntity(), event.getSpell(), event.getLevel()));
    }

    public static void modifySpellSelection(SpellSelectionManager.SpellSelectionEvent event) {
        HashMap spellModifiers = new HashMap();
        ISAttributes.ATTRIBUTE_ENTRIES.forEach(attribute -> {
            AttributeInstance instance = event.getEntity().m_21051_(attribute);
            if (instance == null) {
                return;
            }
            if (attribute.m_22087_().startsWith("attribute.additional_attributes.innate_school/")) {
                SchoolType school = (SchoolType)((IForgeRegistry)SchoolRegistry.REGISTRY.get()).getValue(ISAttributes.getLocation(attribute, "attribute.additional_attributes.innate_school/"));
                for (AbstractSpell spell : ((IForgeRegistry)SpellRegistry.REGISTRY.get()).getValues()) {
                    if (spell.getSchoolType() != school) continue;
                    ISEvents.addModifiers(spellModifiers, instance, spell);
                }
            } else if (attribute.m_22087_().startsWith("attribute.additional_attributes.innate_spell/")) {
                AbstractSpell spell = (AbstractSpell)((IForgeRegistry)SpellRegistry.REGISTRY.get()).getValue(ISAttributes.getLocation(attribute, "attribute.additional_attributes.innate_spell/"));
                ISEvents.addModifiers(spellModifiers, instance, spell);
            }
        });
        int index = 0;
        for (AbstractSpell spell : spellModifiers.keySet()) {
            Pair data = (Pair)spellModifiers.get(spell);
            HashMap modifiers = (HashMap)data.right();
            double base = (Double)data.left();
            for (AttributeModifier modifier : modifiers.getOrDefault(AttributeModifier.Operation.ADDITION, Collections.emptySet())) {
                base += modifier.m_22218_();
            }
            double result = base;
            for (AttributeModifier modifier : modifiers.getOrDefault(AttributeModifier.Operation.MULTIPLY_BASE, Collections.emptySet())) {
                result += base * modifier.m_22218_();
            }
            for (AttributeModifier modifier : modifiers.getOrDefault(AttributeModifier.Operation.MULTIPLY_TOTAL, Collections.emptySet())) {
                result *= 1.0 + modifier.m_22218_();
            }
            int level = (int)result;
            if (level <= 0) continue;
            boolean shouldAdd = true;
            if (((Boolean)ServerConfig.SKIP_INNATE.get()).booleanValue()) {
                List<SpellData> spellEntries = event.getManager().getAllSpells().stream().filter(option -> option.spellData.getSpell() == spell).map(option -> option.spellData).toList();
                for (SpellData entry : spellEntries) {
                    if (entry.getLevel() < level) continue;
                    shouldAdd = false;
                    break;
                }
            }
            if (!shouldAdd) continue;
            event.addSelectionOption(new SpellData(spell, level), "innate_spells", index);
            ++index;
        }
    }

    private static void addModifiers(HashMap<AbstractSpell, Pair<Double, HashMap<AttributeModifier.Operation, Set<AttributeModifier>>>> spellModifiers, AttributeInstance instance, AbstractSpell spell) {
        Pair data = spellModifiers.compute(spell, (key, value) -> {
            if (value == null) {
                return Pair.of((Object)instance.m_22115_(), new HashMap());
            }
            return Pair.of((Object)((Double)value.left() + instance.m_22115_()), (Object)((HashMap)value.right()));
        });
        for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
            ((HashMap)data.right()).computeIfAbsent(operation, key -> new HashSet()).addAll(instance.m_22104_(operation));
        }
    }

    public static void registerAttributes(RegisterEvent event) {
        IForgeRegistry iForgeRegistry;
        if (event.getRegistryKey() == ((IForgeRegistry)SpellRegistry.REGISTRY.get()).getRegistryKey()) {
            IForgeRegistry iForgeRegistry2 = ForgeRegistries.ATTRIBUTES;
            if (iForgeRegistry2 instanceof ForgeRegistry) {
                ForgeRegistry registry = (ForgeRegistry)iForgeRegistry2;
                registry.unfreeze();
                ((IForgeRegistry)SpellRegistry.REGISTRY.get()).getValues().forEach(spell -> {
                    ResourceLocation resource = spell.getSpellResource();
                    if (resource.m_135827_().equals("irons_spellbooks")) {
                        ISAttributes.registerAttribute("spell_type_" + spell.getSpellName());
                    } else {
                        ISAttributes.registerAttribute("spell/" + resource.m_135827_() + "/" + resource.m_135815_());
                    }
                    ISAttributes.registerAttribute("innate_spell/" + resource.m_135827_() + "/" + resource.m_135815_());
                });
                registry.freeze();
            }
        } else if (event.getRegistryKey() == ((IForgeRegistry)SchoolRegistry.REGISTRY.get()).getRegistryKey() && (iForgeRegistry = ForgeRegistries.ATTRIBUTES) instanceof ForgeRegistry) {
            ForgeRegistry registry = (ForgeRegistry)iForgeRegistry;
            registry.unfreeze();
            ((IForgeRegistry)SchoolRegistry.REGISTRY.get()).getValues().forEach(school -> {
                ResourceLocation resource = school.getId();
                if (resource.m_135827_().equals("irons_spellbooks")) {
                    ISAttributes.registerAttribute("spell_school_" + resource.m_135815_());
                } else {
                    ISAttributes.registerAttribute("school/" + resource.m_135827_() + "/" + resource.m_135815_());
                }
                ISAttributes.registerAttribute("innate_school/" + resource.m_135827_() + "/" + resource.m_135815_());
            });
            registry.freeze();
        }
    }
}

