/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelpreview;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import net.creeperhost.levelio.LevelIO;
import net.creeperhost.levelio.data.Level;
import net.creeperhost.levelio.lib.BlockPos;
import net.creeperhost.levelio.lib.nbt.NBTHandler;
import net.creeperhost.levelpreview.CaptureHandler;
import net.creeperhost.levelpreview.ColourMap;
import net.creeperhost.levelpreview.lib.CaptureArea;
import net.creeperhost.levelpreview.lib.SimplePNG;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelPreview {
    private static final Logger LOGGER = LoggerFactory.getLogger(LevelPreview.class);
    public static boolean DEBUG = false;
    private final NBTHandler nbtHandler;
    private LevelIO levelIO;
    private ColourMap colourMap = new ColourMap();

    public LevelPreview(NBTHandler nbtHandler) {
        this.nbtHandler = nbtHandler;
    }

    public void loadWorld(Path worldFolder) throws IOException {
        if (this.levelIO != null) {
            this.levelIO.close();
        }
        this.levelIO = LevelIO.create(worldFolder, true, this.nbtHandler);
    }

    public void loadWorld(LevelIO levelIO) {
        if (this.levelIO != null) {
            this.levelIO.close();
        }
        this.levelIO = levelIO;
    }

    public LevelIO getLevelIO() {
        return this.levelIO;
    }

    public CaptureBuilder newCapture() {
        return new CaptureBuilder(this.colourMap, this.levelIO);
    }

    public ColourMap getColourMap() {
        return this.colourMap;
    }

    public void close() {
        if (this.levelIO != null) {
            this.levelIO.close();
        }
    }

    public static void debug(String message, Object ... params) {
        if (DEBUG) {
            LOGGER.info(message, params);
        }
    }

    public static class CaptureBuilder {
        private final ColourMap colourMap;
        private final LevelIO levelIO;
        protected CaptureArea captureArea = new CaptureArea(null, new BlockPos(-256, 0, -256), new BlockPos(256, 0, 256));
        protected Level level = null;
        protected boolean topography = true;
        protected CaptureHandler.CaptureData data;
        private Map<String, String> metadata;

        private CaptureBuilder(ColourMap colourMap, LevelIO levelIO) {
            this.colourMap = colourMap;
            this.levelIO = levelIO;
        }

        public CaptureBuilder captureArea(int xPos, int zPos, int xSize, int zSize) {
            BlockPos min = new BlockPos(xPos, 0, zPos);
            this.captureArea = new CaptureArea(null, min, min.copy().offset(xSize, 0, zSize));
            return this;
        }

        public CaptureBuilder captureArea(CaptureArea area) {
            this.captureArea = area;
            if (area.level != null) {
                this.level = area.level;
            }
            return this;
        }

        public CaptureBuilder dimension(String dimension) throws IOException {
            this.level = this.levelIO.getLevel(dimension);
            if (this.level == null) {
                throw new IOException("Dimension Not Found: " + dimension);
            }
            return this;
        }

        public CaptureBuilder dimension(Level level) {
            this.level = level;
            return this;
        }

        public CaptureBuilder caveMode() {
            return this;
        }

        public CaptureBuilder topography(boolean topography) {
            this.topography = topography;
            return this;
        }

        public CaptureBuilder doCapture() {
            return this.doCapture(false);
        }

        public CaptureBuilder doCapture(boolean withHeat) {
            this.data = CaptureHandler.capture(this.colourMap, this.level, this.captureArea, withHeat);
            return this;
        }

        public CaptureBuilder setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public void writeCapture(Path file, boolean heatOverlay, boolean heatOnly) throws IOException {
            if (this.data == null) {
                throw new IllegalStateException("Must call doCapture before writeCapture");
            }
            SimplePNG.SimpleImg img = this.getImage(heatOverlay, heatOnly);
            SimplePNG.writePNG(file, img);
        }

        public void writeCapture(Path file) throws IOException {
            this.writeCapture(file, false, false);
        }

        public SimplePNG.SimpleImg getImage(boolean heatOverlay, boolean heatOnly) {
            if (this.data == null) {
                throw new IllegalStateException("Must call doCapture before getImage");
            }
            SimplePNG.SimpleImg img = this.data.generateImage(this.topography, heatOverlay, heatOnly);
            if (this.metadata != null) {
                img.getTextTags().putAll(this.metadata);
            }
            return img;
        }

        public SimplePNG.SimpleImg getImage() {
            return this.getImage(false, false);
        }
    }
}

