/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util;

import de.keksuccino.fancymenu.util.ConsumingSupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListUtils {
    public static <T> void changeIndexOf(@NotNull List<T> list, @NotNull T object, int newIndex) {
        int currentIndex;
        if (list.isEmpty()) {
            return;
        }
        if (newIndex < 0) {
            newIndex = 0;
        }
        if (newIndex > list.size()) {
            newIndex = list.size();
        }
        if ((currentIndex = list.indexOf(Objects.requireNonNull(object))) == -1) {
            return;
        }
        if (currentIndex == newIndex) {
            return;
        }
        list.remove(object);
        list.add(newIndex, object);
    }

    public static <T> void offsetIndexOf(@NotNull List<T> list, @NotNull T object, int indexOffset) {
        int currentIndex = list.indexOf(Objects.requireNonNull(object));
        if (currentIndex == -1) {
            return;
        }
        int newIndex = currentIndex + indexOffset;
        ListUtils.changeIndexOf(list, object, newIndex);
    }

    @Nullable
    public static <T> T getLast(@NotNull List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    @SafeVarargs
    public static <T> List<T> mergeLists(List<T> ... lists) {
        ArrayList<T> l = new ArrayList<T>();
        for (List<T> list : lists) {
            l.addAll(list);
        }
        return l;
    }

    public static boolean allInListEqual(@NotNull List<?> list) {
        if (list.size() < 2) {
            return true;
        }
        Object first = list.get(0);
        for (Object obj : list.subList(1, list.size())) {
            if (Objects.equals(obj, first)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean contentEqualIgnoreOrder(@NotNull List<T> list1, @NotNull List<T> list2) {
        Objects.requireNonNull(list1);
        Objects.requireNonNull(list2);
        if (list1.size() != list2.size()) {
            return false;
        }
        if (list1 == list2) {
            return true;
        }
        for (T obj1 : list1) {
            boolean foundMatch = false;
            for (T obj2 : list2) {
                if (!obj1.equals(obj2)) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    @NotNull
    public static <T> List<T> filterList(@NotNull List<T> listToFilter, @NotNull ConsumingSupplier<T, Boolean> filter) {
        ArrayList<T> l = new ArrayList<T>();
        for (T object : listToFilter) {
            if (!filter.get(object).booleanValue()) continue;
            l.add(object);
        }
        listToFilter.clear();
        listToFilter.addAll(l);
        return listToFilter;
    }

    @SafeVarargs
    @NotNull
    public static <T> List<T> of(T ... entries) {
        return new ArrayList<T>(Arrays.asList(entries));
    }
}

