/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watervision;

import com.mojang.brigadier.CommandDispatcher;
import me.srrapero720.watervision.client.render.TextureWrapper;
import me.srrapero720.watervision.common.commands.VisionCommands;
import me.srrapero720.watervision.common.network.VisionNetwork;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.api.image.ImageAPI;

@Mod(value="watervision")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WaterVision {
    public static final String ID = "watervision";
    public static final Logger LOGGER = LogManager.getLogger((String)"watervision");
    public static final Marker IT = MarkerManager.getMarker((String)"Main");
    public static final ResourceLocation LOADING_ANIM_TEXTURE = ResourceLocation.m_214293_((String)"watervision", (String)"loading_animation");
    private static int ticks = 0;

    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        VisionCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onClientCommandsRegister(RegisterClientCommandsEvent event) {
        VisionCommands.registerClient((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (ticks == Integer.MAX_VALUE) {
                ticks = 0;
            }
            ++ticks;
        }
    }

    public static int getTicks() {
        return ticks;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float deltaFrames() {
        return Minecraft.m_91087_().m_91104_() ? 1.0f : Minecraft.m_91087_().m_91296_();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void setup(FMLCommonSetupEvent event) {
            LOGGER.debug("Registering Network...");
            event.enqueueWork(VisionNetwork::init);
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void clientSetup(FMLClientSetupEvent event) {
            LOGGER.debug("Client setup...");
            event.enqueueWork(() -> Minecraft.m_91087_().m_91097_().m_118495_(LOADING_ANIM_TEXTURE, (AbstractTexture)new TextureWrapper.Renderer(ImageAPI.loadingGif((String)WaterVision.ID))));
        }
    }
}

