/*
 * Decompiled with CFR 0.152.
 */
package pie.ilikepiefoo.compat.jei.impl;

import com.mojang.blaze3d.platform.InputConstants;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pie.ilikepiefoo.compat.jei.builder.RecipeCategoryBuilder;

public class CustomRecipeCategory<T>
implements IRecipeCategory<T> {
    private final RecipeCategoryBuilder<T> builder;

    public CustomRecipeCategory(RecipeCategoryBuilder<T> builder) {
        this.builder = builder;
    }

    @NotNull
    public RecipeType<T> getRecipeType() {
        return this.builder.getRecipeType();
    }

    @NotNull
    public Component getTitle() {
        return this.builder.getCategoryTitle();
    }

    @NotNull
    public IDrawable getBackground() {
        return this.builder.getCategoryBackground();
    }

    public int getWidth() {
        return this.builder.getWidth();
    }

    public int getHeight() {
        return this.builder.getHeight();
    }

    @NotNull
    public IDrawable getIcon() {
        return this.builder.getCategoryIcon();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        if (this.builder.getSetRecipeHandler() == null) {
            return;
        }
        try {
            this.builder.getSetRecipeHandler().setRecipe(builder, recipe, focuses);
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error setting recipe for recipe category: " + String.valueOf(this.builder.getRecipeType().getUid()), e);
        }
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        try {
            if (this.builder.getDrawHandler() != null) {
                this.builder.getDrawHandler().draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
            }
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error drawing recipe category: " + String.valueOf(this.builder.getRecipeType().getUid()), e);
        }
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    @NotNull
    public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        try {
            if (this.builder.getTooltipHandler() != null) {
                return this.builder.getTooltipHandler().getTooltipStrings(recipe, recipeSlotsView, mouseX, mouseY);
            }
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error getting tooltip strings for recipe category: " + String.valueOf(this.builder.getRecipeType().getUid()), e);
        }
        return super.getTooltipStrings(recipe, recipeSlotsView, mouseX, mouseY);
    }

    public boolean handleInput(T recipe, double mouseX, double mouseY, InputConstants.Key input) {
        try {
            if (this.builder.getInputHandler() != null) {
                return this.builder.getInputHandler().handleInput(recipe, mouseX, mouseY, input);
            }
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error handling input for recipe category: " + String.valueOf(this.builder.getRecipeType().getUid()), e);
        }
        return super.handleInput(recipe, mouseX, mouseY, input);
    }

    public boolean isHandled(T recipe) {
        try {
            if (this.builder.getIsRecipeHandledByCategory() != null) {
                return this.builder.getIsRecipeHandledByCategory().isHandled(recipe);
            }
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error checking if recipe is handled by category: " + String.valueOf(this.builder.getRecipeType().getUid()), e);
        }
        return super.isHandled(recipe);
    }

    @Nullable
    public ResourceLocation getRegistryName(T recipe) {
        try {
            if (this.builder.getGetRegisterName() != null) {
                return this.builder.getGetRegisterName().getRegistryName(recipe);
            }
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error getting registry name for recipe category: " + String.valueOf(this.builder.getRecipeType().getUid()), e);
        }
        return super.getRegistryName(recipe);
    }
}

