/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.integration;

import net.mehvahdjukaar.amendments.common.block.CeilingBannerBlock;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.events.behaviors.CauldronConversion;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.GunpowderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SconceBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SconceLeverBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SconceWallBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class SuppCompat {
    public static void setup() {
        FaucetBehaviorsManager.addRegisterFaucetInteraction(() -> FaucetBlockTile.registerInteraction((Object)new FaucetCauldronConversion()));
    }

    public static boolean canBannerAttachToRope(BlockState state, BlockState above) {
        if (above.m_60734_() instanceof RopeBlock && !((Boolean)above.m_61143_((Property)RopeBlock.DOWN)).booleanValue()) {
            Direction dir = (Direction)state.m_61143_((Property)CeilingBannerBlock.FACING);
            return (Boolean)above.m_61143_((Property)RopeBlock.FACING_TO_PROPERTY_MAP.get(dir.m_122427_())) != false && (Boolean)above.m_61143_((Property)RopeBlock.FACING_TO_PROPERTY_MAP.get(dir.m_122428_())) != false;
        }
        return false;
    }

    public static boolean isVerticalStick(BlockState state, Direction facing) {
        return state.m_60734_() instanceof StickBlock && (facing.m_122434_() == Direction.Axis.X ? (Boolean)state.m_61143_((Property)StickBlock.AXIS_X) == false : (Boolean)state.m_61143_((Property)StickBlock.AXIS_Z) == false);
    }

    public static boolean isRope(Block block) {
        return block instanceof RopeBlock;
    }

    public static void spawnCakeParticles(Level level, BlockPos pos, RandomSource rand) {
        if (MiscUtils.FESTIVITY.isStValentine() && (double)rand.m_188501_() > 0.8) {
            double d0 = (double)pos.m_123341_() + 0.5 + ((double)rand.m_188501_() - 0.5);
            double d1 = (double)pos.m_123342_() + 0.5 + ((double)rand.m_188501_() - 0.5);
            double d2 = (double)pos.m_123343_() + 0.5 + ((double)rand.m_188501_() - 0.5);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123750_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static void addOptionalOwnership(Level world, BlockPos pos, @Nullable LivingEntity entity) {
        BlockUtil.addOptionalOwnership((LivingEntity)entity, (Level)world, (BlockPos)pos);
    }

    public static float getSignColorMult() {
        return ClientConfigs.getSignColorMult();
    }

    public static boolean isSupportingCeiling(BlockState upState, BlockPos pos, LevelReader world) {
        return IRopeConnection.isSupportingCeiling((BlockState)upState, (BlockPos)pos, (LevelReader)world);
    }

    public static void createMiniExplosion(ServerLevel level, BlockPos pos, boolean b) {
        GunpowderBlock.createMiniExplosion((Level)level, (BlockPos)pos, (boolean)b);
    }

    public static boolean canConnectDown(BlockState neighborState) {
        return IRopeConnection.canConnectDown((BlockState)neighborState);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static Material getFlagMaterial(Level l, BannerPatternItem bannerPatternItem) {
        return ModMaterials.getFlagMaterialForPatternItem((BannerPatternItem)bannerPatternItem);
    }

    public static boolean isSconce(Block block) {
        if (block instanceof SconceLeverBlock) {
            return true;
        }
        return block instanceof SconceBlock && !(block instanceof SconceWallBlock);
    }

    public static boolean isCandleHolder(Block block) {
        return block instanceof CandleHolderBlock;
    }

    public static EntityType<? extends Entity> getSlimeBall() {
        return (EntityType)ModEntities.THROWABLE_SLIMEBALL.get();
    }

    public static class FaucetCauldronConversion
    implements FaucetTarget.BlState {
        public Integer fill(Level level, BlockPos pos, BlockState target, FluidOffer offer) {
            if (target.m_60713_(Blocks.f_50256_)) {
                SoftFluidStack fluid = offer.fluid();
                int minAmount = offer.minAmount();
                BlockState newState = CauldronConversion.getNewState(pos, level, fluid);
                if (newState != null) {
                    level.m_46597_(pos, newState);
                    BlockEntity blockEntity = level.m_7702_(pos);
                    if (blockEntity instanceof LiquidCauldronBlockTile) {
                        LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
                        SoftFluidTank tank = te.getSoftFluidTank();
                        tank.setFluid(fluid.copyWithCount(minAmount));
                        return minAmount;
                    }
                }
            }
            return null;
        }
    }
}

