/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.mehvahdjukaar.amendments.client.ModRenderTypes;
import net.mehvahdjukaar.amendments.client.renderers.ThrownProjectile3DRenderer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.Nullable;

public class Fireball3DRenderer<E extends Entity>
extends ThrownProjectile3DRenderer<E> {
    private final ModelPart cube;
    private final ModelPart cubeEmissive;
    private final ModelPart overlay;
    private final ResourceLocation overlayTexture;
    @Nullable
    private final ResourceLocation noOverlayTexture;
    private final Function<ResourceLocation, RenderType> renderTypeFunction;

    public Fireball3DRenderer(EntityRendererProvider.Context context, float scale, ResourceLocation texture, ResourceLocation overlayTexture, @Nullable ResourceLocation offTexture, ModelLayerLocation modelLocation, boolean hasNoShade) {
        super(context, scale, texture);
        this.overlayTexture = overlayTexture;
        this.noOverlayTexture = offTexture;
        this.renderTypeFunction = hasNoShade ? ModRenderTypes.ENTITY_LIT : RenderType::m_110452_;
        ModelPart model = context.m_174023_(modelLocation);
        this.cube = model.m_171324_("cube");
        this.cubeEmissive = model.m_171324_("cube_emissive");
        this.overlay = model.m_171324_("overlay");
    }

    protected int m_6086_(E entity, BlockPos pos) {
        if (entity.m_20094_() <= 0 && this.noOverlayTexture != null) {
            return super.m_6086_(entity, pos);
        }
        return entity.m_9236_().m_45517_(LightLayer.BLOCK, pos);
    }

    @Override
    public void renderBall(E entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        boolean hasOverlay = entity.m_20094_() > 0 || this.noOverlayTexture == null;
        ResourceLocation mainTexture = hasOverlay ? this.m_5478_(entity) : this.noOverlayTexture;
        RenderType mainRedderType = this.renderTypeFunction.apply(mainTexture);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(mainRedderType);
        this.cube.m_104301_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_);
        this.cubeEmissive.m_104301_(poseStack, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_);
        if (hasOverlay) {
            float f = (float)((Entity)entity).f_19797_ + partialTick;
            RenderType fireRenderType = RenderType.m_110436_((ResourceLocation)this.overlayTexture, (float)(this.fireXOffset(f) % 1.0f), (float)(f * 0.01f % 1.0f));
            VertexConsumer outlineVertexConsumer = bufferSource.m_6299_(fireRenderType);
            this.overlay.m_104301_(poseStack, outlineVertexConsumer, 0xF000F0, OverlayTexture.f_118083_);
        }
    }

    private float fireXOffset(float tickCount) {
        return tickCount * 0.01f;
    }
}

