/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifierGroup;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifierSerializerRegistry;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.selectors.NamesResourceSelector;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ObjectModifierProvider<T, S, D>
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final String modId;
    private final String name;
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final ObjectModifierSerializerRegistry<T, S, D> serializerRegistry;
    private final BiFunction<RegistryOps<JsonElement>, ObjectModifierGroup<T, S, D>, S> additionalSerializationGetter;
    private final List<EntryBuilder<T, S, D>> entries = new ArrayList<EntryBuilder<T, S, D>>();

    public ObjectModifierProvider(String modId, boolean data, String subDirectory, ObjectModifierSerializerRegistry<T, S, D> serializerRegistry, BiFunction<RegistryOps<JsonElement>, ObjectModifierGroup<T, S, D>, S> additionalSerializationGetter, PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.modId = modId;
        this.name = "Object Modifiers (" + subDirectory + "): " + modId;
        this.pathProvider = output.m_245269_(data ? PackOutput.Target.DATA_PACK : PackOutput.Target.RESOURCE_PACK, "modifiers/" + subDirectory);
        this.lookupProvider = lookupProvider;
        this.serializerRegistry = serializerRegistry;
        this.additionalSerializationGetter = additionalSerializationGetter;
    }

    public ObjectModifierProvider(String modId, boolean data, String subDirectory, ObjectModifierSerializerRegistry<T, S, D> serializerRegistry, S additionalSerializationObject, PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this(modId, data, subDirectory, (ObjectModifierSerializerRegistry<T, BiFunction<RegistryOps, ObjectModifierGroup, Object>, D>)serializerRegistry, (ops, group) -> additionalSerializationObject, output, lookupProvider);
    }

    public CompletableFuture<?> m_213708_(CachedOutput cachedOutput) {
        return this.lookupProvider.thenCompose(provider -> {
            List<EntryBuilder<T, S, D>> entries = this.entries;
            entries.clear();
            this.registerEntries((HolderLookup.Provider)provider);
            PackOutput.PathProvider pathProvider = this.pathProvider;
            BiFunction<RegistryOps<JsonElement>, ObjectModifierGroup<T, S, D>, S> additionalSerializationGetter = this.additionalSerializationGetter;
            RegistryOps registryOps = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)provider);
            ObjectModifierSerializerRegistry<T, S, D> serializerRegistry = this.serializerRegistry;
            return CompletableFuture.allOf((CompletableFuture[])entries.stream().map(entry -> {
                Path resolvedPath = pathProvider.m_245731_(new ResourceLocation(this.modId, entry.name));
                ObjectModifierGroup group = new ObjectModifierGroup(entry.selector, entry.modifiers, entry.priority);
                try {
                    return DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)group.serialize(additionalSerializationGetter.apply(registryOps, group), serializerRegistry, (ICondition[][])entry.conditions.toArray((T[])new ICondition[0][])), (Path)resolvedPath);
                }
                catch (JsonParseException exception) {
                    LOGGER.error("Couldn't save modifier group {}", (Object)resolvedPath, (Object)exception);
                    return CompletableFuture.completedFuture(null);
                }
            }).toArray(CompletableFuture[]::new));
        });
    }

    protected abstract void registerEntries(HolderLookup.Provider var1);

    protected EntryBuilder<T, S, D> entry(String name) {
        EntryBuilder entryBuilder = new EntryBuilder(name);
        this.entries.add(entryBuilder);
        return entryBuilder;
    }

    public String m_6055_() {
        return this.name;
    }

    public static final class EntryBuilder<T, S, D> {
        private final String name;
        private final LinkedList<ObjectModifier<T, S, D, ?>> modifiers = new LinkedList();
        private final ArrayList<ICondition[]> conditions = new ArrayList();
        private ConditionedResourceSelector selector = ConditionedResourceSelector.EMPTY;
        private EventPriority priority = EventPriority.NORMAL;

        public EntryBuilder(String name) {
            this.name = name;
        }

        public EntryBuilder<T, S, D> selector(ConditionedResourceSelector selector) {
            this.selector = selector;
            return this;
        }

        public EntryBuilder<T, S, D> selector(ResourceSelector<?> selector) {
            return this.selector(new ConditionedResourceSelector(selector));
        }

        public EntryBuilder<T, S, D> selects(ResourceLocation ... names) {
            return this.selector(new NamesResourceSelector(names));
        }

        public EntryBuilder<T, S, D> selects(String ... names) {
            return this.selector(new NamesResourceSelector(names));
        }

        public EntryBuilder<T, S, D> addModifier(ObjectModifier<T, S, D, ?> modifier, ICondition ... conditions) {
            this.modifiers.add(modifier);
            this.conditions.add(conditions);
            return this;
        }

        public EntryBuilder<T, S, D> priority(EventPriority priority) {
            this.priority = priority;
            return this;
        }
    }
}

