/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.mixin;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.common.world.storage.tracking.SyncType;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedData;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.blueprint.core.events.EntityStepEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements IDataManager,
Endimatable {
    @Shadow
    public Level f_19853_;
    @Shadow
    private Vec3 f_19825_;
    private Map<TrackedData<?>, IDataManager.DataEntry<?>> dataMap = Maps.newHashMap();
    private boolean dirty = false;
    private final Endimatable.EndimatedState endimatedState = new Endimatable.EndimatedState(this);

    @Shadow
    public abstract BlockPos m_20097_();

    @Override
    public <T> void setValue(TrackedData<T> trackedData, T value) {
        IDataManager.DataEntry entry = this.dataMap.computeIfAbsent(trackedData, IDataManager.DataEntry::new);
        if (!entry.getValue().equals(value)) {
            boolean dirty = !this.f_19853_.f_46443_ && entry.getTrackedData().getSyncType() != SyncType.NOPE;
            entry.setValue(value, dirty);
            this.dirty = dirty;
        }
    }

    @Override
    public <T> T getValue(TrackedData<T> trackedData) {
        return this.dataMap.computeIfAbsent(trackedData, IDataManager.DataEntry::new).getValue();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void clean() {
        this.dataMap.values().forEach(IDataManager.DataEntry::clean);
        this.dirty = false;
    }

    @Override
    public void setDataMap(Map<TrackedData<?>, IDataManager.DataEntry<?>> dataMap) {
        this.dirty = true;
        this.dataMap = dataMap;
    }

    @Override
    public Map<TrackedData<?>, IDataManager.DataEntry<?>> getDataMap() {
        return this.dataMap;
    }

    @Override
    public Set<IDataManager.DataEntry<?>> getDirtyEntries() {
        HashSet dirtyEntries = Sets.newHashSet();
        for (IDataManager.DataEntry<?> entry : this.dataMap.values()) {
            if (!entry.isDirty() || entry.getTrackedData().getSyncType() == SyncType.NOPE) continue;
            dirtyEntries.add(entry);
        }
        return dirtyEntries;
    }

    @Override
    public Set<IDataManager.DataEntry<?>> getEntries(boolean syncToAll) {
        HashSet dirtyEntries = Sets.newHashSet();
        for (IDataManager.DataEntry<?> entry : this.dataMap.values()) {
            SyncType syncType = entry.getTrackedData().getSyncType();
            if (!(syncToAll ? syncType == SyncType.TO_CLIENTS : syncType != SyncType.NOPE)) continue;
            dirtyEntries.add(entry);
        }
        return dirtyEntries;
    }

    @Override
    public Endimatable.EndimatedState getEndimatedState() {
        return this.endimatedState;
    }

    @Override
    public Position getPos() {
        return this.f_19825_;
    }

    @Override
    public boolean isActive() {
        return this.m_6084_();
    }

    @Shadow
    public boolean m_6084_() {
        return false;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift=At.Shift.BEFORE)}, method={"saveWithoutId"})
    private void writeTrackedData(CompoundTag compound, CallbackInfoReturnable<CompoundTag> info) {
        if (!this.dataMap.isEmpty()) {
            ListTag dataListTag = new ListTag();
            this.dataMap.forEach((trackedData, dataEntry) -> {
                if (trackedData.shouldSave()) {
                    CompoundTag dataTag = dataEntry.writeValue();
                    dataTag.m_128359_("Id", TrackedDataManager.INSTANCE.getKey((TrackedData<?>)trackedData).toString());
                    dataListTag.add((Object)dataTag);
                }
            });
            compound.m_128365_("BlueprintTrackedData", (Tag)dataListTag);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift=At.Shift.BEFORE)}, method={"load"})
    public void read(CompoundTag compound, CallbackInfo info) {
        if (compound.m_128425_("BlueprintTrackedData", 9)) {
            ListTag dataListTag = compound.m_128437_("BlueprintTrackedData", 10);
            dataListTag.forEach(nbt -> {
                CompoundTag dataTag = (CompoundTag)nbt;
                ResourceLocation id = new ResourceLocation(dataTag.m_128461_("Id"));
                TrackedData<?> trackedData = TrackedDataManager.INSTANCE.getTrackedData(id);
                if (trackedData != null && trackedData.shouldSave()) {
                    IDataManager.DataEntry dataEntry = new IDataManager.DataEntry(trackedData);
                    dataEntry.readValue(dataTag, true);
                    this.dataMap.put(trackedData, dataEntry);
                } else if (trackedData == null) {
                    Blueprint.LOGGER.warn("Received NBT for unknown Tracked Data: {}", (Object)id);
                }
            });
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;push(Ljava/lang/String;)V", shift=At.Shift.AFTER)}, method={"baseTick"})
    private void baseTick(CallbackInfo info) {
        this.endimateTick();
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;stepOn(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/Entity;)V"))
    private void onIsSteppingCarefully(Block block, Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!EntityStepEvent.onEntityStep(this.f_19853_, this.m_20097_(), state, entity)) {
            block.m_141947_(level, pos, state, entity);
        }
    }
}

