/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api.conditions.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.teamabnormals.blueprint.core.registry.BlueprintLootConditions;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class RandomDifficultyChanceCondition
implements LootItemCondition {
    private final float defaultChance;
    private final float peacefulChance;
    private final float easyChance;
    private final float normalChance;
    private final float hardChance;

    public RandomDifficultyChanceCondition(float defaultChance, float peacefulChance, float easyChance, float normalChance, float hardChance) {
        this.defaultChance = defaultChance;
        this.peacefulChance = peacefulChance;
        this.easyChance = easyChance;
        this.normalChance = normalChance;
        this.hardChance = hardChance;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)BlueprintLootConditions.RANDOM_DIFFICULTY_CHANCE.get();
    }

    public boolean test(LootContext lootContext) {
        float chance = this.defaultChance;
        switch (lootContext.m_78952_().m_46791_()) {
            case PEACEFUL: {
                if (!(this.peacefulChance >= 0.0f)) break;
                chance = this.peacefulChance;
                break;
            }
            case EASY: {
                if (!(this.easyChance >= 0.0f)) break;
                chance = this.easyChance;
                break;
            }
            case NORMAL: {
                if (!(this.normalChance >= 0.0f)) break;
                chance = this.normalChance;
                break;
            }
            case HARD: {
                if (!(this.hardChance >= 0.0f)) break;
                chance = this.hardChance;
            }
        }
        return lootContext.m_230907_().m_188501_() < chance;
    }

    public static class RandomDifficultyChanceSerializer
    implements Serializer<RandomDifficultyChanceCondition> {
        private static float getFloatOrMinus1(JsonObject json, String fieldName) {
            return json.has(fieldName) ? GsonHelper.m_13915_((JsonObject)json, (String)fieldName) : -1.0f;
        }

        public void serialize(JsonObject json, RandomDifficultyChanceCondition condition, JsonSerializationContext context) {
            json.addProperty("default_chance", (Number)Float.valueOf(condition.defaultChance));
            if (condition.peacefulChance >= 0.0f) {
                json.addProperty("peaceful", (Number)Float.valueOf(condition.peacefulChance));
            }
            if (condition.easyChance >= 0.0f) {
                json.addProperty("easy", (Number)Float.valueOf(condition.easyChance));
            }
            if (condition.normalChance >= 0.0f) {
                json.addProperty("normal", (Number)Float.valueOf(condition.normalChance));
            }
            if (condition.hardChance >= 0.0f) {
                json.addProperty("hard", (Number)Float.valueOf(condition.hardChance));
            }
        }

        public RandomDifficultyChanceCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            if (json.has("default_chance")) {
                return new RandomDifficultyChanceCondition(GsonHelper.m_13915_((JsonObject)json, (String)"default_chance"), RandomDifficultyChanceSerializer.getFloatOrMinus1(json, "peaceful"), RandomDifficultyChanceSerializer.getFloatOrMinus1(json, "easy"), RandomDifficultyChanceSerializer.getFloatOrMinus1(json, "normal"), RandomDifficultyChanceSerializer.getFloatOrMinus1(json, "hard"));
            }
            throw new JsonSyntaxException("Missing 'default_chance', expected to find a float");
        }
    }
}

