/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.teamabnormals.blueprint.core.annotations.ConfigKey;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public final class BlueprintConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    private static String makeTranslation(String name) {
        return "blueprint.config." + name;
    }

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
    }

    public static final class Client {
        @ConfigKey(value="screen_shake_scale")
        public final ForgeConfigSpec.ConfigValue<Double> screenShakeScaleValue;
        public double screenShakeScale;
        @ConfigKey(value="max_screen_shakers")
        public final ForgeConfigSpec.ConfigValue<Integer> maxScreenShakersValue;
        public int maxScreenShakers;
        @ConfigKey(value="disable_experimental_settings_screen")
        public final ForgeConfigSpec.ConfigValue<Boolean> disableExperimentalSettingsScreenValue;
        public boolean disableExperimentalSettingsScreen;
        public final SlabfishSettings slabfishSettings;

        Client(ForgeConfigSpec.Builder builder) {
            this.screenShakeScaleValue = builder.comment("Scale for screen shake effects").translation(BlueprintConfig.makeTranslation("screen_shake_scale")).defineInRange("screenShakeScale", 1.0, 0.0, 1.0);
            this.maxScreenShakersValue = builder.comment("Max amount of sources that can contribute to screen shaking, adjustable for performance and preference reasons. 0 will disable the addition of shake sources").translation(BlueprintConfig.makeTranslation("max_screen_shakers")).defineInRange("maxScreenShakers", 256, 0, Integer.MAX_VALUE);
            this.disableExperimentalSettingsScreenValue = builder.comment("Determines if the experimental settings screen should be disabled").translation(BlueprintConfig.makeTranslation("disable_experimental_settings_screen")).define("disableExperimentalSettingsScreen", true);
            this.slabfishSettings = new SlabfishSettings(builder);
        }

        public void load() {
            this.screenShakeScale = (Double)this.screenShakeScaleValue.get();
            this.maxScreenShakers = (Integer)this.maxScreenShakersValue.get();
            this.disableExperimentalSettingsScreen = (Boolean)this.disableExperimentalSettingsScreenValue.get();
        }
    }

    public static final class Common {
        public final ForgeConfigSpec.ConfigValue<CommentedConfig> moddedBiomeSliceSizes;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"The modded biome slice sizes for dimensions", "Blueprint's Modded Biome Slice System allows for datapacks and mods to add new biome areas to any dimension", "Changing the size values will affect the size of all modded biome areas in their respected dimension", "If a slice size isn't a positive integer, it will get ignored and the default slice size will get used instead"});
            CommentedConfig config = TomlFormat.newConfig();
            config.setComment("default", "If the slice size for a dimension isn't defined, this value will get used for that dimension");
            config.set("default", (Object)8);
            config.setComment("minecraft:overworld", "For example, the overworld's slice size would be formatted like this");
            config.set("minecraft:overworld", (Object)8);
            this.moddedBiomeSliceSizes = builder.define("modded_biome_slice_sizes", (Object)config);
        }
    }

    public static final class SlabfishSettings {
        @ConfigKey(value="slabfish_hat_enabled")
        public final ForgeConfigSpec.ConfigValue<Boolean> enabled;
        @ConfigKey(value="slabfish_hat_backpack_enabled")
        public final ForgeConfigSpec.ConfigValue<Boolean> backpackEnabled;
        @ConfigKey(value="slabfish_hat_sweater_enabled")
        public final ForgeConfigSpec.ConfigValue<Boolean> sweaterEnabled;
        @ConfigKey(value="slabfish_hat_custom_type_enabled")
        public final ForgeConfigSpec.ConfigValue<Boolean> typeEnabled;

        SlabfishSettings(ForgeConfigSpec.Builder builder) {
            builder.comment("Slabfish patron hat settings.").push("slabfishSettings");
            this.enabled = builder.comment("If the slabfish hat should be enabled").translation(BlueprintConfig.makeTranslation("slabfishHat")).define("enabled", true);
            this.backpackEnabled = builder.comment("If the slabfish hat's backpack should be enabled").translation(BlueprintConfig.makeTranslation("slabfishHat.backpack")).define("backpackEnabled", true);
            this.sweaterEnabled = builder.comment("If the slabfish hat's sweater should be enabled").translation(BlueprintConfig.makeTranslation("slabfishHat.sweater")).define("sweaterEnabled", true);
            this.typeEnabled = builder.comment("If the slabfish hat's custom type should be enabled. If false, the default swamp slabfish appears").translation(BlueprintConfig.makeTranslation("slabfishHat.type")).define("typeEnabled", true);
            builder.pop();
        }
    }
}

