/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.packet;

import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.login.ClientLoginPacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketCustomChannelBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Supplier<String> CONST_1 = () -> "1";
    private final NetworkRegistry.ChannelBuilder parent;
    private final ResourceLocation channelName;
    private Supplier<String> networkProtocolVersion = CONST_1;
    private Predicate<String> clientAcceptedVersions = SneakyUtils.trueP();
    private Predicate<String> serverAcceptedVersions = SneakyUtils.trueP();
    private ICustomPacketHandler.IClientPacketHandler clientHandler;
    private ICustomPacketHandler.IServerPacketHandler serverHandler;
    private ICustomPacketHandler.ILoginPacketHandler loginHandler;

    private PacketCustomChannelBuilder(ResourceLocation channelName) {
        this.channelName = channelName;
        this.parent = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelName);
    }

    public static PacketCustomChannelBuilder named(ResourceLocation channelName) {
        return new PacketCustomChannelBuilder(channelName);
    }

    public PacketCustomChannelBuilder networkProtocolVersion(Supplier<String> networkProtocolVersion) {
        this.networkProtocolVersion = networkProtocolVersion;
        return this;
    }

    public PacketCustomChannelBuilder clientAcceptedVersions(Predicate<String> clientAcceptedVersions) {
        this.clientAcceptedVersions = clientAcceptedVersions;
        return this;
    }

    public PacketCustomChannelBuilder serverAcceptedVersions(Predicate<String> serverAcceptedVersions) {
        this.serverAcceptedVersions = serverAcceptedVersions;
        return this;
    }

    public PacketCustomChannelBuilder assignClientHandler(Supplier<Supplier<ICustomPacketHandler.IClientPacketHandler>> clientHandler) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.clientHandler = clientHandler.get().get();
        }
        return this;
    }

    public PacketCustomChannelBuilder assignServerHandler(Supplier<Supplier<ICustomPacketHandler.IServerPacketHandler>> serverHandler) {
        this.serverHandler = serverHandler.get().get();
        return this;
    }

    public PacketCustomChannelBuilder assignLoginHandler(Supplier<Supplier<ICustomPacketHandler.ILoginPacketHandler>> loginHandler) {
        this.loginHandler = loginHandler.get().get();
        return this;
    }

    public synchronized EventNetworkChannel build() {
        EventNetworkChannel channel = this.parent.networkProtocolVersion(this.networkProtocolVersion).clientAcceptedVersions(this.clientAcceptedVersions).serverAcceptedVersions(this.serverAcceptedVersions).eventNetworkChannel();
        if (this.clientHandler != null) {
            channel.registerObject((Object)new ClientHandler(this.clientHandler));
        }
        if (this.serverHandler != null) {
            channel.registerObject((Object)new ServerHandler(this.serverHandler));
        }
        if (this.loginHandler != null) {
            channel.registerObject((Object)new LoginHandler(this.loginHandler));
        }
        return channel;
    }

    private class ClientHandler {
        private final ICustomPacketHandler.IClientPacketHandler packetHandler;

        public ClientHandler(ICustomPacketHandler.IClientPacketHandler packetHandler) {
            this.packetHandler = packetHandler;
        }

        @SubscribeEvent
        public void onClientPayload(NetworkEvent.ServerCustomPayloadEvent event) {
            if (event instanceof NetworkEvent.ServerCustomPayloadLoginEvent) {
                return;
            }
            ByteBuf payload = event.getPayload().copy();
            PacketCustom packet = new PacketCustom(payload);
            NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
            PacketListener netHandler = ctx.getNetworkManager().m_129538_();
            ctx.setPacketHandled(true);
            if (netHandler instanceof ClientPacketListener) {
                ClientPacketListener nh = (ClientPacketListener)netHandler;
                ctx.enqueueWork(() -> {
                    try {
                        this.packetHandler.handlePacket(packet, Minecraft.m_91087_(), nh);
                    }
                    catch (Throwable ex) {
                        LOGGER.error("Error handling packet on channel {}.", (Object)PacketCustomChannelBuilder.this.channelName, (Object)ex);
                    }
                    finally {
                        payload.release();
                    }
                });
            }
        }
    }

    private class ServerHandler {
        private final ICustomPacketHandler.IServerPacketHandler packetHandler;

        public ServerHandler(ICustomPacketHandler.IServerPacketHandler packetHandler) {
            this.packetHandler = packetHandler;
        }

        @SubscribeEvent
        public void onServerPayload(NetworkEvent.ClientCustomPayloadEvent event) {
            ByteBuf payload = event.getPayload().copy();
            PacketCustom packet = new PacketCustom(payload);
            NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
            PacketListener netHandler = ctx.getNetworkManager().m_129538_();
            ctx.setPacketHandled(true);
            if (netHandler instanceof ServerGamePacketListenerImpl) {
                ServerGamePacketListenerImpl nh = (ServerGamePacketListenerImpl)netHandler;
                ctx.enqueueWork(() -> {
                    try {
                        this.packetHandler.handlePacket(packet, nh.f_9743_, nh);
                    }
                    catch (Throwable ex) {
                        LOGGER.error("Error handling packet on channel {}.", (Object)PacketCustomChannelBuilder.this.channelName, (Object)ex);
                    }
                    finally {
                        payload.release();
                    }
                });
            }
        }
    }

    private class LoginHandler {
        private final ICustomPacketHandler.ILoginPacketHandler packetHandler;

        public LoginHandler(ICustomPacketHandler.ILoginPacketHandler packetHandler) {
            this.packetHandler = packetHandler;
        }

        @SubscribeEvent
        public void onGatherLoginPayloads(NetworkEvent.GatherLoginPayloadsEvent event) {
            this.packetHandler.gatherLoginPackets((ctx, packetSupplier) -> {
                PacketCustom packet = (PacketCustom)packetSupplier.get();
                event.add(packet.toPacketBuffer(), packet.getChannel(), ctx);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public void onClientPayload(NetworkEvent.LoginPayloadEvent event) {
            ByteBuf payload = event.getPayload().copy();
            PacketCustom packet = new PacketCustom(payload);
            NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
            PacketListener netHandler = ctx.getNetworkManager().m_129538_();
            ctx.setPacketHandled(true);
            if (netHandler instanceof ClientLoginPacketListener) {
                ClientLoginPacketListener nh = (ClientLoginPacketListener)netHandler;
                try {
                    this.packetHandler.handleLoginPacket(packet, Minecraft.m_91087_(), nh, ctx);
                }
                catch (Throwable ex) {
                    LOGGER.error("Error handling login packet on channel {}.", (Object)PacketCustomChannelBuilder.this.channelName, (Object)ex);
                }
                finally {
                    payload.release();
                    ctx.getPacketDispatcher().sendPacket(new ResourceLocation("fml:handshake"), new FriendlyByteBuf(Unpooled.buffer().writeByte(99)));
                }
            }
        }
    }
}

