/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.client;

import codechicken.lib.internal.HighlightHandler;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.util.LambdaUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class HighlightCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"ccl").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"highlight").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").executes(HighlightCommand::setHighlightRayTrace)).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(HighlightCommand::setHighlightArg)))).then(Commands.m_82127_((String)"clear").executes(HighlightCommand::clearHighlight))).then(Commands.m_82127_((String)"toggle_depth").executes(HighlightCommand::toggleDepth))).then(Commands.m_82127_((String)"info").executes(HighlightCommand::dumpInfo))));
    }

    private static int setHighlightRayTrace(CommandContext<CommandSourceStack> ctx) {
        BlockHitResult hitResult = RayTracer.retrace((Player)Minecraft.m_91087_().f_91074_, 3000.0, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Not looking at a block."));
            return 0;
        }
        return HighlightCommand.setHighlight(ctx, hitResult.m_82425_());
    }

    private static int setHighlightArg(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return HighlightCommand.setHighlight(ctx, BlockPosArgument.m_174395_(ctx, (String)"pos"));
    }

    private static int setHighlight(CommandContext<CommandSourceStack> ctx, BlockPos pos) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (HighlightHandler.highlight == null) {
            source.m_288197_(() -> Component.m_237113_((String)("Set highlight at " + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_())), false);
        } else {
            BlockPos prev = HighlightHandler.highlight;
            source.m_288197_(() -> Component.m_237113_((String)("Moved highlight from " + prev.m_123341_() + ", " + prev.m_123342_() + ", " + prev.m_123343_() + " to " + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_())), false);
        }
        HighlightHandler.highlight = pos;
        return 0;
    }

    private static int clearHighlight(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (HighlightHandler.highlight == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Highlight not set."));
            return 0;
        }
        HighlightHandler.highlight = null;
        HighlightHandler.useDepth = true;
        source.m_288197_(() -> Component.m_237113_((String)"Highlight position cleared."), false);
        return 0;
    }

    private static int toggleDepth(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (HighlightHandler.highlight == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Highlight not set."));
            return 0;
        }
        boolean bl = HighlightHandler.useDepth = !HighlightHandler.useDepth;
        if (HighlightHandler.useDepth) {
            source.m_288197_(() -> Component.m_237113_((String)"Enabled highlight depth."), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"Disabled highlight depth."), false);
        }
        return 0;
    }

    private static int dumpInfo(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        BlockPos pos = HighlightHandler.highlight;
        if (HighlightHandler.highlight == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Highlight not set."));
            return 0;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        assert (level != null);
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        BlockEntity tile = level.m_7702_(pos);
        StringBuilder builder = new StringBuilder("\nBlock info:\n");
        builder.append("  BlockPos:      ").append(String.format("x:%s, y:%s, z:%s", pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).append("\n");
        builder.append("  Block Class:   ").append(LambdaUtils.tryOrNull(() -> block.getClass())).append("\n");
        builder.append("  Registry Name: ").append(LambdaUtils.tryOrNull(() -> ForgeRegistries.BLOCKS.getKey((Object)block))).append("\n");
        builder.append("  State:         ").append(state).append("\n");
        builder.append("Tile at position\n");
        builder.append("  Tile Class:    ").append(LambdaUtils.tryOrNull(() -> tile.getClass())).append("\n");
        builder.append("  Tile Id:       ").append(LambdaUtils.tryOrNull(() -> ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)tile.m_58903_()))).append("\n");
        builder.append("  Tile NBT:      ").append(LambdaUtils.tryOrNull(() -> tile.m_187482_())).append("\n");
        source.m_288197_(() -> Component.m_237113_((String)builder.toString()), false);
        return 0;
    }
}

