/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.geometry.Borders;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.sprite.Material;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiTexture
extends GuiElement<GuiTexture>
implements BackgroundRender {
    private Supplier<Material> getMaterial;
    private Supplier<Integer> colour = () -> -1;
    private Borders dynamicBorders = null;
    private Supplier<Integer> rotation = () -> 0;

    public GuiTexture(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public GuiTexture(@NotNull GuiParent<?> parent, Supplier<Material> supplier) {
        super(parent);
        this.setMaterial(supplier);
    }

    public GuiTexture(@NotNull GuiParent<?> parent, Material material) {
        super(parent);
        this.setMaterial(material);
    }

    public GuiTexture setMaterial(Supplier<Material> supplier) {
        this.getMaterial = supplier;
        return this;
    }

    public GuiTexture setMaterial(Material material) {
        this.getMaterial = () -> material;
        return this;
    }

    @Nullable
    public Material getMaterial() {
        return this.getMaterial == null ? null : this.getMaterial.get();
    }

    public GuiTexture dynamicTexture() {
        return this.dynamicTexture(5);
    }

    public GuiTexture dynamicTexture(int textureBorders) {
        return this.dynamicTexture(Borders.create(textureBorders));
    }

    public GuiTexture dynamicTexture(Borders textureBorders) {
        this.dynamicBorders = textureBorders;
        return this;
    }

    public GuiTexture setColour(int colourARGB) {
        return this.setColour(() -> colourARGB);
    }

    public GuiTexture setColour(Supplier<Integer> colour) {
        this.colour = colour;
        return this;
    }

    public GuiTexture setRotation(Supplier<Integer> rotation) {
        this.rotation = rotation;
        return this;
    }

    public GuiTexture setRotation(int rotation) {
        this.rotation = () -> rotation;
        return this;
    }

    @Override
    public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        Material material = this.getMaterial();
        if (material == null) {
            return;
        }
        if (this.dynamicBorders != null) {
            render.dynamicTex(material, this.getRectangle(), this.dynamicBorders, this.colour.get());
        } else {
            render.texRect(material, this.rotation.get(), this.getRectangle(), this.colour.get());
        }
    }
}

