/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.splendidslimes.util;

import dev.shadowsoffire.placebo.reload.DynamicHolder;
import io.github.chakyl.splendidslimes.data.SlimeBreed;
import io.github.chakyl.splendidslimes.entity.SplendidSlime;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class SlimeUtils {
    public static MobEffectInstance copyEffect(SplendidSlime slime, MobEffectInstance effect) {
        boolean putrid = slime.hasTrait("putrid");
        return new MobEffectInstance(effect.m_19544_(), effect.m_19557_() * (putrid ? effect.m_19557_() : 1), effect.m_19564_() + (putrid ? 1 : 0), effect.m_19571_(), effect.m_19572_());
    }

    public static void applyEffects(SplendidSlime slime, LivingEntity entity, List<MobEffectInstance> effects, boolean particles) {
        if (particles) {
            slime.setParticleAnimationTick(0);
        }
        for (MobEffectInstance effect : effects) {
            if (effect == null || entity == null) continue;
            entity.m_7292_(SlimeUtils.copyEffect(slime, effect));
        }
    }

    public static void applyNegativeEffects(SplendidSlime splendidSlime, LivingEntity entity, boolean particles) {
        DynamicHolder<SlimeBreed> slime = splendidSlime.getSlime();
        DynamicHolder<SlimeBreed> secondarySlime = splendidSlime.getSecondarySlime();
        if (!slime.isBound()) {
            return;
        }
        if (!splendidSlime.hasSameBreed(entity).booleanValue()) {
            List<MobEffectInstance> secondarySlimeEffects;
            List<MobEffectInstance> effects = ((SlimeBreed)slime.get()).negativeEmitEffects();
            if (secondarySlime.isBound() && !(secondarySlimeEffects = ((SlimeBreed)secondarySlime.get()).negativeEmitEffects()).isEmpty()) {
                SlimeUtils.applyEffects(splendidSlime, entity, secondarySlimeEffects, particles);
            }
            if (!effects.isEmpty()) {
                SlimeUtils.applyEffects(splendidSlime, entity, effects, particles);
            }
        }
    }

    public static void applyPositiveEffects(SplendidSlime splendidSlime, LivingEntity entity, boolean particles) {
        List<MobEffectInstance> secondarySlimeEffects;
        DynamicHolder<SlimeBreed> slime = splendidSlime.getSlime();
        DynamicHolder<SlimeBreed> secondarySlime = splendidSlime.getSecondarySlime();
        if (!slime.isBound()) {
            return;
        }
        List<MobEffectInstance> effects = ((SlimeBreed)slime.get()).positiveEmitEffects();
        if (secondarySlime.isBound() && !(secondarySlimeEffects = ((SlimeBreed)secondarySlime.get()).positiveEmitEffects()).isEmpty()) {
            SlimeUtils.applyEffects(splendidSlime, entity, secondarySlimeEffects, particles);
        }
        if (!effects.isEmpty()) {
            SlimeUtils.applyEffects(splendidSlime, entity, effects, particles);
        }
    }

    private static CommandSourceStack createCommandSourceStack(@Nullable Player pPlayer, Entity pEntity, Level pLevel, BlockPos pPos, Component displayName) {
        String s = pPlayer == null ? "Splendid Slime" : pPlayer.m_7755_().getString();
        Component component = pPlayer == null ? displayName : pPlayer.m_5446_();
        return new CommandSourceStack(CommandSource.f_80164_, Vec3.m_82512_((Vec3i)pPos), Vec2.f_82462_, (ServerLevel)pLevel, 2, s, component, pLevel.m_7654_(), pEntity);
    }

    public static void runCommands(SplendidSlime splendidSlime, List<String> commands) {
        CommandSourceStack source = SlimeUtils.createCommandSourceStack(null, (Entity)splendidSlime, splendidSlime.m_9236_(), splendidSlime.m_20097_(), splendidSlime.m_5446_());
        source.m_81329_((Entity)splendidSlime);
        source.m_81324_();
        for (String command : commands) {
            splendidSlime.m_20194_().m_129892_().m_230957_(source, command);
        }
    }

    public static void executeSlimeCommands(SplendidSlime splendidSlime, boolean positive, boolean attack) {
        DynamicHolder<SlimeBreed> slime = splendidSlime.getSlime();
        DynamicHolder<SlimeBreed> secondarySlime = splendidSlime.getSecondarySlime();
        if (!slime.isBound()) {
            return;
        }
        if (attack) {
            SlimeUtils.runCommands(splendidSlime, ((SlimeBreed)slime.get()).attackCommands());
            if (secondarySlime.isBound()) {
                SlimeUtils.runCommands(splendidSlime, ((SlimeBreed)secondarySlime.get()).attackCommands());
            }
        } else if (positive) {
            SlimeUtils.runCommands(splendidSlime, ((SlimeBreed)slime.get()).positiveCommands());
            if (secondarySlime.isBound()) {
                SlimeUtils.runCommands(splendidSlime, ((SlimeBreed)secondarySlime.get()).positiveCommands());
            }
        } else {
            SlimeUtils.runCommands(splendidSlime, ((SlimeBreed)slime.get()).negativeCommands());
            if (secondarySlime.isBound()) {
                SlimeUtils.runCommands(splendidSlime, ((SlimeBreed)secondarySlime.get()).negativeCommands());
            }
        }
    }

    public static void handleHungryTraits(SplendidSlime splendidSlime) {
        double chance = 1.0 - ((double)splendidSlime.getEatingCooldown() + 1.0) / (double)SplendidSlime.SLIME_HUNGRY_THRESHOLD;
        if ((double)splendidSlime.m_217043_().m_188501_() <= chance) {
            if (splendidSlime.hasTrait("explosive")) {
                splendidSlime.m_9236_().m_255391_((Entity)splendidSlime, splendidSlime.m_20185_(), splendidSlime.m_20186_(), splendidSlime.m_20189_(), splendidSlime.hasTrait("flaming") ? 3.0f : 4.0f, splendidSlime.hasTrait("flaming"), Level.ExplosionInteraction.NONE);
            }
            if (splendidSlime.hasTrait("flaming")) {
                BlockPos blockpos = splendidSlime.m_20097_();
                if (splendidSlime.m_9236_().m_46859_(blockpos)) {
                    splendidSlime.m_9236_().m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)splendidSlime.m_9236_(), (BlockPos)blockpos));
                }
            }
        }
    }

    public static boolean cry(SplendidSlime slime, Level level) {
        if (level.m_6042_().f_63857_()) {
            return true;
        }
        int x = Mth.m_14107_((double)slime.m_20185_());
        int y = Mth.m_14107_((double)slime.m_20186_());
        int z = Mth.m_14107_((double)slime.m_20189_());
        int radius = 2;
        for (int i = 0; i < radius; ++i) {
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)new BlockPos(x - radius, y - i, z - radius), (BlockPos)new BlockPos(x + radius, y + i, z + radius))) {
                BlockState scannedBlockState = level.m_8055_(pos);
                if (scannedBlockState.m_60734_() != Blocks.f_50016_ && scannedBlockState.m_60819_() != Fluids.f_76192_.m_76145_()) continue;
                level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
                slime.m_5496_(SoundEvents.f_11919_, 0.4f, 0.2f);
                return true;
            }
        }
        slime.m_5496_(SoundEvents.f_11922_, 0.6f, (float)Math.random());
        return false;
    }
}

